use crate::Result;
use lapin::{message::Delivery, options::BasicRejectOptions, Channel};
use std::sync::Arc;

pub async fn job_parameter_error(
  channel: Arc<Channel>,
  message: Option<Delivery>,
  details: &str,
) -> Result<()> {
  log::error!("Parameter value error: {}", details);
  if let Some(delivery) = message {
    channel
      .basic_reject(delivery.delivery_tag, BasicRejectOptions::default())
      .await
      .map_err(|e| e.into())
  } else {
    Ok(())
  }
}
