use crate::Result;
use lapin::{message::Delivery, options::BasicRejectOptions, Channel};
use std::sync::Arc;

pub async fn job_not_implemented(channel: Arc<Channel>, delivery: Option<Delivery>) -> Result<()> {
  log::error!("Not implemented feature");
  if let Some(delivery) = delivery {
    channel
      .basic_reject(
        delivery.delivery_tag,
        BasicRejectOptions { requeue: true }, /*requeue*/
      )
      .await
      .map_err(|e| e.into())
  } else {
    Ok(())
  }
}
