use crate::Result;
use lapin::{message::Delivery, options::BasicRejectOptions, Channel};
use std::sync::Arc;

pub async fn job_missing_requirements(
  channel: Arc<Channel>,
  delivery: Option<Delivery>,
  details: &str,
) -> Result<()> {
  log::error!("{}", details);
  if let Some(delivery) = delivery {
    channel
      .basic_reject(delivery.delivery_tag, BasicRejectOptions::default())
      .await
      .map_err(|e| e.into())
  } else {
    Ok(())
  }
}
