mod common;
mod credential;
mod job;
mod user;
mod worker;
mod worker_definition;
mod workflow;
mod workflow_definition;
mod workflow_instance;

pub use common::{
  Coordinates, Icon, Identifier, JobsStatus, Parameter, ParameterType, Step, StepMode, Store,
  WorkflowDuration,
};
pub use credential::{Credential, CredentialContent};
pub use job::Job;
pub use user::User;
pub use worker::Worker;
pub use worker_definition::WorkerDefinition;
pub use workflow::Workflow;
pub use workflow_definition::WorkflowDefinition;
pub use workflow_instance::{Status, WorkflowInstance};

#[macro_use]
extern crate lazy_static;

pub(crate) fn is_false(value: &bool) -> bool {
  !*value
}
