use super::{Step, WorkflowDefinition, WorkflowInstance};
use crate::common::Job;

#[derive(Clone, PartialEq)]
pub enum Workflow {
  Definition(WorkflowDefinition),
  Instance(WorkflowInstance),
}

impl Workflow {
  pub fn is_definition(&self) -> bool {
    match self {
      Workflow::Definition(_) => true,
      Workflow::Instance(_) => false,
    }
  }

  pub fn identifier(&self) -> &str {
    match self {
      Workflow::Definition(workflow) => workflow.identifier(),
      Workflow::Instance(workflow) => &workflow.identifier,
    }
  }

  pub fn reference(&self) -> Option<String> {
    match self {
      Workflow::Definition(_) => None,
      Workflow::Instance(workflow) => workflow.reference.clone(),
    }
  }

  pub fn jobs(&self) -> Option<&Vec<Job>> {
    match self {
      Workflow::Definition(_) => None,
      Workflow::Instance(workflow) => Some(&workflow.jobs),
    }
  }

  pub fn steps(&self) -> &Vec<Step> {
    match self {
      Workflow::Definition(workflow) => workflow.steps(),
      Workflow::Instance(workflow) => &workflow.steps,
    }
  }
}
