use crate::subcommands::get_required_parameter_as_string;
use clap::ArgMatches;
use std::convert::TryFrom;

type Pretty = bool;

#[derive(Debug)]
pub enum Output {
  Formatted,
  Json(Pretty),
  Raw,
}

impl<'a> TryFrom<&Option<&ArgMatches<'a>>> for Output {
  type Error = crate::Error;

  fn try_from(matches: &Option<&ArgMatches<'a>>) -> Result<Self, Self::Error> {
    let output = match get_required_parameter_as_string(matches, "output")?.as_str() {
      "json" => Output::Json(false),
      "pretty-json" => Output::Json(true),
      "formatted" => Output::Formatted,
      _ => Output::Raw,
    };

    Ok(output)
  }
}
