use super::{workflow_columns, Workflow};
use crate::models::Render;
use serde::{Deserialize, Serialize};
use term_table::{Table, TableStyle};

#[derive(Deserialize, Serialize)]
pub struct WorkflowSingle {
  pub(crate) data: Workflow,
}

impl Render for WorkflowSingle {
  fn render(&self) {
    let mut table = Table::new();
    table.style = TableStyle::rounded();
    table.add_row(workflow_columns());
    table.add_row((&self.data).into());
    println!("{}", table.render());
  }
}
