use super::{worker_columns, Worker};
use crate::models::Render;
use serde::{Deserialize, Serialize};
use term_table::{Table, TableStyle};

#[derive(Deserialize, Serialize)]
pub struct WorkerSingle {
  #[serde(flatten)]
  data: Worker,
}

impl Render for WorkerSingle {
  fn render(&self) {
    let mut table = Table::new();
    table.style = TableStyle::rounded();
    table.add_row(worker_columns());
    table.add_row((&self.data).into());
    println!("{}", table.render());
  }
}
