use super::{worker_columns, Worker};
use crate::models::Render;
use serde::{Deserialize, Serialize};
use term_table::{
  row::Row,
  table_cell::{Alignment, TableCell},
  Table, TableStyle,
};

#[derive(Deserialize, Serialize)]
pub struct WorkerMultiple {
  data: Vec<Worker>,
  total: usize,
}

impl Render for WorkerMultiple {
  fn render(&self) {
    let mut table = Table::new();
    table.style = TableStyle::rounded();
    table.add_row(worker_columns());

    for workflow in &self.data {
      table.add_row(workflow.into());
    }

    table.add_row(Row::new(vec![TableCell::new_with_alignment(
      format!("{}-{}/{}", 0, self.data.len(), self.total),
      4,
      Alignment::Right,
    )]));

    println!("{}", table.render());
  }
}
