use serde::{Deserialize, Serialize};
use term_table::{row::Row, table_cell::TableCell};

#[derive(Deserialize, Serialize)]
pub struct Worker {
  activity: String,
  current_job: Option<u32>,
  description: String,
  direct_messaging_queue_name: String,
  instance_id: String,
  label: String,
  queue_name: String,
  sdk_version: String,
  short_description: String,
  system_info: SystemInfo,
  version: String,
}

#[derive(Deserialize, Serialize)]
pub struct SystemInfo {
  docker_container_id: String,
  number_of_processors: u32,
  total_memory: u32,
  total_swap: u32,
  used_memory: u32,
  used_swap: u32,
}

impl<'a> From<&Worker> for Row<'a> {
  fn from(worker: &Worker) -> Row<'a> {
    Row::new(vec![
      TableCell::new(&worker.instance_id),
      TableCell::new(&worker.activity),
      TableCell::new(&worker.version),
      TableCell::new(&worker.queue_name),
    ])
  }
}

pub fn worker_columns<'a>() -> Row<'a> {
  Row::new(vec![
    TableCell::new("ID"),
    TableCell::new("Activity"),
    TableCell::new("Version"),
    TableCell::new("Queue Name"),
  ])
}
