use crate::models::{user_columns, Render, User};
use serde::{Deserialize, Serialize};
use term_table::{Table, TableStyle};

#[derive(Deserialize, Serialize)]
pub struct UserSingle {
  pub data: User,
}

impl Render for UserSingle {
  fn render(&self) {
    let mut table = Table::new();
    table.style = TableStyle::rounded();
    table.add_row(user_columns());
    table.add_row((&self.data).into());
    println!("{}", table.render());
  }
}
