use crate::models::{user_columns, Render, User};
use serde::Deserialize;
use term_table::{
  row::Row,
  table_cell::{Alignment, TableCell},
  Table, TableStyle,
};

#[derive(Deserialize)]
pub struct UserMultiple {
  data: Vec<User>,
  total: usize,
}

impl Render for UserMultiple {
  fn render(&self) {
    let mut table = Table::new();
    table.style = TableStyle::rounded();
    table.add_row(user_columns());

    for user in &self.data {
      table.add_row(user.into());
    }

    table.add_row(Row::new(vec![TableCell::new_with_alignment(
      format!("{}-{}/{}", 0, self.data.len(), self.total),
      2,
      Alignment::Right,
    )]));

    println!("{}", table.render());
  }
}
