use serde::{Deserialize, Serialize};
use term_table::{row::Row, table_cell::TableCell};

#[derive(Deserialize, Serialize)]
pub struct User {
  pub(crate) access_key_id: Option<u32>,
  pub(crate) confirmed_at: String,
  pub(crate) email: String,
  pub(crate) id: u32,
  pub(crate) inserted_at: String,
  pub(crate) rights: Vec<String>,
  pub(crate) uuid: String,
}

impl<'a> From<&User> for Row<'a> {
  fn from(user: &User) -> Row<'a> {
    Row::new(vec![
      TableCell::new(&user.id),
      TableCell::new(&user.email),
      TableCell::new(&user.rights.join(", ")),
    ])
  }
}

pub fn user_columns<'a>() -> Row<'a> {
  Row::new(vec![
    TableCell::new("ID"),
    TableCell::new("Email"),
    TableCell::new("Rights"),
  ])
}
