use super::{credential_columns, Credential};
use crate::models::Render;
use serde::{Deserialize, Serialize};
use term_table::{Table, TableStyle};

#[derive(Deserialize, Serialize)]
pub struct CredentialSingle {
  pub(crate) data: Credential,
}

impl Render for CredentialSingle {
  fn render(&self) {
    let mut table = Table::new();
    table.style = TableStyle::rounded();
    table.add_row(credential_columns());
    table.add_row((&self.data).into());
    println!("{}", table.render());
  }
}
