use crate::models::{credential_columns, Credential, Render};
use serde::Deserialize;
use term_table::{
  row::Row,
  table_cell::{Alignment, TableCell},
  Table, TableStyle,
};

#[derive(Deserialize)]
pub struct CredentialMultiple {
  data: Vec<Credential>,
  total: usize,
}

impl Render for CredentialMultiple {
  fn render(&self) {
    let mut table = Table::new();
    table.style = TableStyle::rounded();
    table.add_row(credential_columns());

    for credential in &self.data {
      table.add_row(credential.create_row_with_hidden_value());
    }

    table.add_row(Row::new(vec![TableCell::new_with_alignment(
      format!("{}-{}/{}", 0, self.data.len(), self.total),
      4,
      Alignment::Right,
    )]));

    println!("{}", table.render());
  }
}
