use crate::Result;
use serde::Serialize;

#[derive(Serialize)]
#[serde(tag = "event", rename_all = "snake_case")]
pub enum WorkflowAction {
  Abort,
  Delete,
}

impl WorkflowAction {
  pub(crate) fn as_body(&self) -> Result<String> {
    Ok(serde_json::to_string(self)?)
  }
}
