use crate::Result;
use serde::Serialize;

#[derive(Serialize)]
#[serde(tag = "type", rename_all = "snake_case")]
pub enum WorkerAction {
  ResumeConsumingJobs,
  StopConsumingJobs,
  StopWorker,
}

impl WorkerAction {
  pub(crate) fn as_body(&self) -> Result<String> {
    Ok(serde_json::to_string(self)?)
  }
}
