//
//  mbus-httpd - An HTTP microservice exposing M-Bus Functionality
//  Copyright (C) 2019-2020 packom.net
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <https://www.gnu.org/licenses/>.
//

//! Main binary entry point for mbus_api implementation.

#![allow(missing_docs)]

use httpd_util::{get_server_addr, https, init_app, ssl};
use log::debug;

#[path = "http.rs"]
mod http;
#[path = "server.rs"]
mod server;

use http::get_env;

/// Create custom server, wire it to the autogenerated router,
/// and pass it to the web server.
#[tokio::main]
async fn main() {
    init_app(
        "mbus-httpd",
        "packom.net, mbus@packom.net",
        "An HTTP(S) microservice exposing M-Bus functionality\n(C) Copyright 2019  packom.net",
        vec![
            "[LIBMBUS_PATH] - Path to libmbus binaries",
            "[LIBMBUS_GET] - libmbus get binary",
            "[LIBMBUS_SCAN] - libmbus scan binary",
            "[LD_LIBRARY_PATH] - Path containing libmbus.so, used by libmbus binaries",
        ],
        get_env(),
    );

    let ssl = match https() {
        true => Some(ssl().unwrap()),
        _ => None,
    };
    match ssl {
        Some(_) => debug!("Using SSL"),
        None => debug!("Not using SSL"),
    }

    let addr_socket = get_server_addr();
    let addr_string = format!("{}:{}", addr_socket.ip(), addr_socket.port());
    debug!("Bind to: {}", addr_string);
    server::create(&addr_string, ssl).await;
}
