# AoC 2021

This contains efficient solutions for all Advent of Code 2021 puzzles.  See [AOC 2021](https://adventofcode.com/2021) for more information.

# Goal

Execute all puzzles before the JVM can start up (~800ms).

# Benchmarking

All solutions are benchmarked on a *Intel(R) Core(TM) i7-6700K CPU* @ 4.00GHz.

Highlights:
- 128KB L1D$
- 1 MB L2$
- DDR4-3200MHz CL16-16-16-36
- Hyper-threading enabled

These benchmarks aren't scientific - each puzzle is run once, in order, on a varyingly loaded
desktop system.

```
Day 1 (35.85µs)
 · Generator (34.62µs)
 · Part 1 (227.00ns) .............. 1475
 · Part 2 (996.00ns) .............. 1515

Day 2 (30.49µs)
 · Generator (20.08µs)
 · Part 1 (5.07µs) ................ 1604850
 · Part 2 (5.35µs) ................ 1685186100

Day 3 (49.95µs)
 · Generator (21.12µs)
 · Part 1 (4.99µs) ................ 2498354
 · Part 2 (23.83µs) ............... 3277956

Day 4 (171.21µs)
 · Generator (46.96µs)
 · Part 1 (29.52µs) ............... 23177
 · Part 2 (94.74µs) ............... 6804

Day 5 (1.44ms)
 · Generator (41.57µs)
 · Part 1 (854.33µs) .............. 7644
 · Part 2 (543.85µs) .............. 18627

Day 6 (3.39µs)
 · Generator (3.28µs)
 · Part 1 (31.00ns) ............... 394994
 · Part 2 (81.00ns) ............... 1765974267455

Day 7 (56.37µs)
 · Generator (50.52µs)
 · Part 1 (283.00ns) .............. 343441
 · Part 2 (5.56µs) ................ 98925151

Day 8 (126.20µs)
 · Generator (116.04µs)
 · Part 1 (1.99µs) ................ 495
 · Part 2 (8.17µs) ................ 1055164

Day 9 (369.12µs)
 · Generator (10.55µs)
 · Part 1 (79.46µs) ............... 577
 · Part 2 (279.11µs) .............. 1069200

Day 10 (145.22µs)
 · Generator (5.31µs)
 · Part 1 (69.80µs) ............... 290691
 · Part 2 (70.12µs) ............... 2768166558

Day 11 (322.08µs)
 · Generator (761.00ns)
 · Part 1 (58.02µs) ............... 1588
 · Part 2 (263.31µs) .............. 517

Day 12 (2.22ms)
 · Generator (4.17µs)
 · Part 1 (100.17µs) .............. 5457
 · Part 2 (2.12ms) ................ 128506

Day 13 (130.95µs)
 · Generator (60.56µs)
 · Part 1 (14.27µs) ............... 847
 · Part 2 (56.12µs) ............... BCZRCEAB

Day 14 (16.25µs)
 · Generator (8.54µs)
 · Part 1 (2.37µs) ................ 3230
 · Part 2 (5.34µs) ................ 3542388214529

Day 15 (12.13ms)
 · Generator (8.18µs)
 · Part 1 (431.07µs) .............. 537
 · Part 2 (11.69ms) ............... 2881

Day 16 (23.98µs)
 · Generator (8.70µs)
 · Part 1 (7.16µs) ................ 1007
 · Part 2 (8.12µs) ................ 834151779165

Day 17 (32.88µs)
 · Generator (1.24µs)
 · Part 1 (30.00ns) ............... 13041
 · Part 2 (31.61µs) ............... 1031

Day 18 (356.70µs)
 · Generator (16.40µs)
 · Part 1 (236.41µs) .............. 4480
 · Part 2 (103.89µs) .............. 4676

Day 19 (3.40ms)
 · Generator (474.76µs)
 · Part 1 (1.46ms) ................ 472
 · Part 2 (1.46ms) ................ 12092

Day 20 (2.70ms)
 · Generator (10.29µs)
 · Part 1 (48.71µs) ............... 4917
 · Part 2 (2.64ms) ................ 16389

Day 21 (538.75µs)
 · Generator (204.00ns)
 · Part 1 (1.10µs) ................ 513936
 · Part 2 (537.45µs) .............. 105619718613031

Day 22 (2.24ms)
 · Generator (106.17µs)
 · Part 1 (28.67µs) ............... 527915
 · Part 2 (2.10ms) ................ 1218645427221987

Day 23 (42.24ms)
 · Generator (643.00ns)
 · Part 1 (3.51ms) ................ 15338
 · Part 2 (38.73ms) ............... 47064

Day 24 (9.05µs)
 · Generator (8.72µs)
 · Part 1 (157.00ns) .............. 99919765949498
 · Part 2 (172.00ns) .............. 24913111616151

Day 25 (22.42ms)
 · Generator (22.47µs)
 · Part 1 (22.39ms) ............... 305
 · Part 2 (29.00ns) ............... merry christmas!

Overall runtime (91.73ms)
```
