/// This trait defines the execute function that can be called on a contract.
/// The implementation is generated by the derive macro but this trait must
/// be included by the contract implementation.
pub trait ContractInterface {
    fn execute(&mut self, payload: &[u8]) -> Result<Vec<u8>, ContractErrors>;
}

#[derive(Debug)]
pub enum ContractErrors {
    InvalidInputType,
    InvalidFunctionName,
}
