#[doc = "Register `LOOP` reader"]
pub struct R(crate::R<LOOP_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LOOP_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LOOP_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LOOP_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LOOP` writer"]
pub struct W(crate::W<LOOP_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LOOP_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LOOP_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LOOP_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `counter_0` reader - CH1 Loop Counter 1"]
pub struct COUNTER_0_R(crate::FieldReader<u16, u16>);
impl COUNTER_0_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        COUNTER_0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COUNTER_0_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `counter_0` writer - CH1 Loop Counter 1"]
pub struct COUNTER_0_W<'a> {
    w: &'a mut W,
}
impl<'a> COUNTER_0_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xffff) | (value as u32 & 0xffff);
        self.w
    }
}
#[doc = "Field `counter_1` reader - CH1 Loop Counter 0"]
pub struct COUNTER_1_R(crate::FieldReader<u16, u16>);
impl COUNTER_1_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        COUNTER_1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COUNTER_1_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `counter_1` writer - CH1 Loop Counter 0"]
pub struct COUNTER_1_W<'a> {
    w: &'a mut W,
}
impl<'a> COUNTER_1_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xffff << 16)) | ((value as u32 & 0xffff) << 16);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:15 - CH1 Loop Counter 1"]
    #[inline(always)]
    pub fn counter_0(&self) -> COUNTER_0_R {
        COUNTER_0_R::new((self.bits & 0xffff) as u16)
    }
    #[doc = "Bits 16:31 - CH1 Loop Counter 0"]
    #[inline(always)]
    pub fn counter_1(&self) -> COUNTER_1_R {
        COUNTER_1_R::new(((self.bits >> 16) & 0xffff) as u16)
    }
}
impl W {
    #[doc = "Bits 0:15 - CH1 Loop Counter 1"]
    #[inline(always)]
    pub fn counter_0(&mut self) -> COUNTER_0_W {
        COUNTER_0_W { w: self }
    }
    #[doc = "Bits 16:31 - CH1 Loop Counter 0"]
    #[inline(always)]
    pub fn counter_1(&mut self) -> COUNTER_1_W {
        COUNTER_1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Channel Loop Counters\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [loop_](index.html) module"]
pub struct LOOP_SPEC;
impl crate::RegisterSpec for LOOP_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [loop_::R](R) reader structure"]
impl crate::Readable for LOOP_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [loop_::W](W) writer structure"]
impl crate::Writable for LOOP_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LOOP to value 0"]
impl crate::Resettable for LOOP_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
