#![doc = "Peripheral access API for MAX3263X microcontrollers (generated using svd2rust v0.20.0 ( ))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.20.0/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[doc = r"Number available in the NVIC for configuring priority"]
pub const NVIC_PRIO_BITS: u8 = 3;
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
pub use cortex_m::peripheral::Peripherals as CorePeripherals;
pub use cortex_m::peripheral::{CBP, CPUID, DCB, DWT, FPB, FPU, ITM, MPU, NVIC, SCB, SYST, TPIU};
#[cfg(feature = "rt")]
pub use cortex_m_rt::interrupt;
#[allow(unused_imports)]
use generic::*;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "C" {
    fn CLKMAN();
    fn POWERMANAGER();
    fn FLC();
    fn RTC_COMP0();
    fn RTC_COMP1();
    fn RTC_PRESCALE_COMP();
    fn RTC_OVERFLOW();
    fn PMU();
    fn USB();
    fn AES();
    fn MAA();
    fn WDT0();
    fn WDT0_PRE_WIN();
    fn WDT1();
    fn WDT1_PRE_WIN();
    fn GPIO0();
    fn GPIO1();
    fn GPIO2();
    fn GPIO3();
    fn GPIO4();
    fn GPIO5();
    fn GPIO6();
    fn TMR0();
    fn TMR16_0();
    fn TMR1();
    fn TMR16_1();
    fn TMR2();
    fn TMR16_2();
    fn TMR3();
    fn TMR16_3();
    fn TMR4();
    fn TMR16_4();
    fn TMR5();
    fn TMR16_5();
    fn UART0();
    fn UART1();
    fn UART2();
    fn UART3();
    fn PT();
    fn I2CM0();
    fn I2CM1();
    fn I2CM2();
    fn I2CS();
    fn SPIM0();
    fn SPIM1();
    fn SPIM2();
    fn OWM();
    fn ADC();
    fn SPIS();
    fn GPIO7();
    fn GPIO8();
}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 52] = [
    Vector { _handler: CLKMAN },
    Vector {
        _handler: POWERMANAGER,
    },
    Vector { _handler: FLC },
    Vector {
        _handler: RTC_COMP0,
    },
    Vector {
        _handler: RTC_COMP1,
    },
    Vector {
        _handler: RTC_PRESCALE_COMP,
    },
    Vector {
        _handler: RTC_OVERFLOW,
    },
    Vector { _handler: PMU },
    Vector { _handler: USB },
    Vector { _handler: AES },
    Vector { _handler: MAA },
    Vector { _handler: WDT0 },
    Vector {
        _handler: WDT0_PRE_WIN,
    },
    Vector { _handler: WDT1 },
    Vector {
        _handler: WDT1_PRE_WIN,
    },
    Vector { _handler: GPIO0 },
    Vector { _handler: GPIO1 },
    Vector { _handler: GPIO2 },
    Vector { _handler: GPIO3 },
    Vector { _handler: GPIO4 },
    Vector { _handler: GPIO5 },
    Vector { _handler: GPIO6 },
    Vector { _handler: TMR0 },
    Vector { _handler: TMR16_0 },
    Vector { _handler: TMR1 },
    Vector { _handler: TMR16_1 },
    Vector { _handler: TMR2 },
    Vector { _handler: TMR16_2 },
    Vector { _handler: TMR3 },
    Vector { _handler: TMR16_3 },
    Vector { _handler: TMR4 },
    Vector { _handler: TMR16_4 },
    Vector { _handler: TMR5 },
    Vector { _handler: TMR16_5 },
    Vector { _handler: UART0 },
    Vector { _handler: UART1 },
    Vector { _handler: UART2 },
    Vector { _handler: UART3 },
    Vector { _handler: PT },
    Vector { _handler: I2CM0 },
    Vector { _handler: I2CM1 },
    Vector { _handler: I2CM2 },
    Vector { _handler: I2CS },
    Vector { _handler: SPIM0 },
    Vector { _handler: SPIM1 },
    Vector { _handler: SPIM2 },
    Vector { _reserved: 0 },
    Vector { _handler: OWM },
    Vector { _handler: ADC },
    Vector { _handler: SPIS },
    Vector { _handler: GPIO7 },
    Vector { _handler: GPIO8 },
];
#[doc = r"Enumeration of all the interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[repr(u16)]
pub enum Interrupt {
    #[doc = "0 - Clock Management IRQ"]
    CLKMAN = 0,
    #[doc = "1 - Power Manager IRQ"]
    POWERMANAGER = 1,
    #[doc = "2 - Flash Controller IRQ"]
    FLC = 2,
    #[doc = "3 - RTC Compare 0 IRQ"]
    RTC_COMP0 = 3,
    #[doc = "4 - RTC Compare 1 IRQ"]
    RTC_COMP1 = 4,
    #[doc = "5 - RTC Prescale Compare IRQ"]
    RTC_PRESCALE_COMP = 5,
    #[doc = "6 - RTC Overflow IRQ"]
    RTC_OVERFLOW = 6,
    #[doc = "7 - Peripheral Manament IRQ"]
    PMU = 7,
    #[doc = "8 - USB IRQ"]
    USB = 8,
    #[doc = "9 - AES IRQ"]
    AES = 9,
    #[doc = "10 - Modular Arithematic Accelerator IRQ"]
    MAA = 10,
    #[doc = "11 - Watch Dog Timer 0 IRQ"]
    WDT0 = 11,
    #[doc = "12 - Watch Dog Timer 0 Pre-Window IRQ"]
    WDT0_PRE_WIN = 12,
    #[doc = "13 - Watch Dog Timer 1 IRQ"]
    WDT1 = 13,
    #[doc = "14 - Watch Dog Timer 1 Pre-Window IRQ"]
    WDT1_PRE_WIN = 14,
    #[doc = "15 - GPIO Port 0 IRQ"]
    GPIO0 = 15,
    #[doc = "16 - GPIO Port 1 IRQ"]
    GPIO1 = 16,
    #[doc = "17 - GPIO Port 2 IRQ"]
    GPIO2 = 17,
    #[doc = "18 - GPIO Port 3 IRQ"]
    GPIO3 = 18,
    #[doc = "19 - GPIO Port 4 IRQ"]
    GPIO4 = 19,
    #[doc = "20 - GPIO Port 5 IRQ"]
    GPIO5 = 20,
    #[doc = "21 - GPIO Port 6 IRQ"]
    GPIO6 = 21,
    #[doc = "22 - Timer 0 IRQ"]
    TMR0 = 22,
    #[doc = "23 - 16-bit Timer 0 IRQ"]
    TMR16_0 = 23,
    #[doc = "24 - Timer 1 IRQ"]
    TMR1 = 24,
    #[doc = "25 - 16-bit Timer 1 IRQ"]
    TMR16_1 = 25,
    #[doc = "26 - Timer 2 IRQ"]
    TMR2 = 26,
    #[doc = "27 - 16-bit Timer 2 IRQ"]
    TMR16_2 = 27,
    #[doc = "28 - Timer 3 IRQ"]
    TMR3 = 28,
    #[doc = "29 - 16-bit Timer 3 IRQ"]
    TMR16_3 = 29,
    #[doc = "30 - Timer 4 IRQ"]
    TMR4 = 30,
    #[doc = "31 - 16-bit Timer 4 IRQ"]
    TMR16_4 = 31,
    #[doc = "32 - Timer 5 IRQ"]
    TMR5 = 32,
    #[doc = "33 - 16-bit Timer 5 IRQ"]
    TMR16_5 = 33,
    #[doc = "34 - UART 0 IRQ"]
    UART0 = 34,
    #[doc = "35 - UART 1 IRQ"]
    UART1 = 35,
    #[doc = "36 - UART 2 IRQ"]
    UART2 = 36,
    #[doc = "37 - UART 3 IRQ"]
    UART3 = 37,
    #[doc = "38 - Pulse Train IRQ"]
    PT = 38,
    #[doc = "39 - I2C Master 0 IRQ"]
    I2CM0 = 39,
    #[doc = "40 - I2C Master 1 IRQ"]
    I2CM1 = 40,
    #[doc = "41 - I2C Master 2 IRQ"]
    I2CM2 = 41,
    #[doc = "42 - I2C Slave IRQ"]
    I2CS = 42,
    #[doc = "43 - SPI Master 0 IRQ"]
    SPIM0 = 43,
    #[doc = "44 - SPI Master 1 IRQ"]
    SPIM1 = 44,
    #[doc = "45 - SPI Master 2 IRQ"]
    SPIM2 = 45,
    #[doc = "47 - 1-Wire Master IRQ"]
    OWM = 47,
    #[doc = "48 - ADC IRQ"]
    ADC = 48,
    #[doc = "49 - SPI Slave IRQ"]
    SPIS = 49,
    #[doc = "50 - GPIO Port 7 IRQ"]
    GPIO7 = 50,
    #[doc = "51 - GPIO Port 8 IRQ"]
    GPIO8 = 51,
}
unsafe impl cortex_m::interrupt::InterruptNumber for Interrupt {
    #[inline(always)]
    fn number(self) -> u16 {
        self as u16
    }
}
#[doc = "System Clock Manager"]
pub struct CLKMAN {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CLKMAN {}
impl CLKMAN {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const clkman::RegisterBlock = 0x4000_0400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const clkman::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CLKMAN {
    type Target = clkman::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CLKMAN {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CLKMAN").finish()
    }
}
#[doc = "System Clock Manager"]
pub mod clkman;
#[doc = "System Power Manager"]
pub struct PWRMAN {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWRMAN {}
impl PWRMAN {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwrman::RegisterBlock = 0x4000_0800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwrman::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWRMAN {
    type Target = pwrman::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWRMAN {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWRMAN").finish()
    }
}
#[doc = "System Power Manager"]
pub mod pwrman;
#[doc = "Real Time Clock"]
pub struct RTCTMR {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTCTMR {}
impl RTCTMR {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtctmr::RegisterBlock = 0x4000_0a00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtctmr::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTCTMR {
    type Target = rtctmr::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTCTMR {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTCTMR").finish()
    }
}
#[doc = "Real Time Clock"]
pub mod rtctmr;
#[doc = "RTC Configuration Register"]
pub struct RTCCFG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTCCFG {}
impl RTCCFG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtccfg::RegisterBlock = 0x4000_0a70 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtccfg::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTCCFG {
    type Target = rtccfg::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTCCFG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTCCFG").finish()
    }
}
#[doc = "RTC Configuration Register"]
pub mod rtccfg;
#[doc = "Power Sequencer"]
pub struct PWRSEQ {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWRSEQ {}
impl PWRSEQ {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwrseq::RegisterBlock = 0x4000_0a30 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwrseq::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWRSEQ {
    type Target = pwrseq::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWRSEQ {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWRSEQ").finish()
    }
}
#[doc = "Power Sequencer"]
pub mod pwrseq;
#[doc = "System I/O Manager"]
pub struct IOMAN {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IOMAN {}
impl IOMAN {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ioman::RegisterBlock = 0x4000_0c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ioman::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IOMAN {
    type Target = ioman::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IOMAN {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IOMAN").finish()
    }
}
#[doc = "System I/O Manager"]
pub mod ioman;
#[doc = "Flash Controller"]
pub struct FLC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLC {}
impl FLC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flc::RegisterBlock = 0x4000_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLC {
    type Target = flc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLC").finish()
    }
}
#[doc = "Flash Controller"]
pub mod flc;
#[doc = "Instruction Cache Controller"]
pub struct ICC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ICC {}
impl ICC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const icc::RegisterBlock = 0x4000_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const icc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ICC {
    type Target = icc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ICC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ICC").finish()
    }
}
#[doc = "Instruction Cache Controller"]
pub mod icc;
#[doc = "SPI XIP Interface"]
pub struct SPIX {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIX {}
impl SPIX {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spix::RegisterBlock = 0x4000_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spix::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIX {
    type Target = spix::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIX {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIX").finish()
    }
}
#[doc = "SPI XIP Interface"]
pub mod spix;
#[doc = "Peripheral Management Unit"]
pub struct PMU0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PMU0 {}
impl PMU0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pmu0::RegisterBlock = 0x4000_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pmu0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PMU0 {
    type Target = pmu0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PMU0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PMU0").finish()
    }
}
#[doc = "Peripheral Management Unit"]
pub mod pmu0;
#[doc = "Peripheral Management Unit"]
pub struct PMU1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PMU1 {}
impl PMU1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pmu0::RegisterBlock = 0x4000_5020 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pmu0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PMU1 {
    type Target = pmu0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PMU1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PMU1").finish()
    }
}
#[doc = "Peripheral Management Unit"]
pub use pmu0 as pmu1;
#[doc = "Peripheral Management Unit"]
pub struct PMU2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PMU2 {}
impl PMU2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pmu0::RegisterBlock = 0x4000_5040 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pmu0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PMU2 {
    type Target = pmu0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PMU2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PMU2").finish()
    }
}
#[doc = "Peripheral Management Unit"]
pub use pmu0 as pmu2;
#[doc = "Peripheral Management Unit"]
pub struct PMU3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PMU3 {}
impl PMU3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pmu0::RegisterBlock = 0x4000_5060 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pmu0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PMU3 {
    type Target = pmu0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PMU3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PMU3").finish()
    }
}
#[doc = "Peripheral Management Unit"]
pub use pmu0 as pmu3;
#[doc = "Peripheral Management Unit"]
pub struct PMU4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PMU4 {}
impl PMU4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pmu0::RegisterBlock = 0x4000_5080 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pmu0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PMU4 {
    type Target = pmu0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PMU4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PMU4").finish()
    }
}
#[doc = "Peripheral Management Unit"]
pub use pmu0 as pmu4;
#[doc = "Peripheral Management Unit"]
pub struct PMU5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PMU5 {}
impl PMU5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pmu0::RegisterBlock = 0x4000_50a0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pmu0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PMU5 {
    type Target = pmu0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PMU5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PMU5").finish()
    }
}
#[doc = "Peripheral Management Unit"]
pub use pmu0 as pmu5;
#[doc = "USB Device Controller"]
pub struct USB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USB {}
impl USB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usb::RegisterBlock = 0x4010_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usb::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USB {
    type Target = usb::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USB").finish()
    }
}
#[doc = "USB Device Controller"]
pub mod usb;
#[doc = "CRC-16/CRC-32 Engine"]
pub struct CRC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CRC {}
impl CRC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const crc::RegisterBlock = 0x4000_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const crc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CRC {
    type Target = crc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CRC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CRC").finish()
    }
}
#[doc = "CRC-16/CRC-32 Engine"]
pub mod crc;
#[doc = "Trust Protection Unit (TPU)"]
pub struct TPU {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TPU {}
impl TPU {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tpu::RegisterBlock = 0x4000_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tpu::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TPU {
    type Target = tpu::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TPU {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TPU").finish()
    }
}
#[doc = "Trust Protection Unit (TPU)"]
pub mod tpu;
#[doc = "Trust Protection Unit (TPU)"]
pub struct TPU_TSR {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TPU_TSR {}
impl TPU_TSR {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tpu_tsr::RegisterBlock = 0x4000_7c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tpu_tsr::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TPU_TSR {
    type Target = tpu_tsr::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TPU_TSR {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TPU_TSR").finish()
    }
}
#[doc = "Trust Protection Unit (TPU)"]
pub mod tpu_tsr;
#[doc = "AES Cryptographic Engine"]
pub struct AES {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for AES {}
impl AES {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const aes::RegisterBlock = 0x4000_7400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const aes::RegisterBlock {
        Self::PTR
    }
}
impl Deref for AES {
    type Target = aes::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for AES {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("AES").finish()
    }
}
#[doc = "AES Cryptographic Engine"]
pub mod aes;
#[doc = "MAA Cryptographic Engine"]
pub struct MAA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for MAA {}
impl MAA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const maa::RegisterBlock = 0x4000_7800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const maa::RegisterBlock {
        Self::PTR
    }
}
impl Deref for MAA {
    type Target = maa::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for MAA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("MAA").finish()
    }
}
#[doc = "MAA Cryptographic Engine"]
pub mod maa;
#[doc = "Watchdog Timers"]
pub struct WDT0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WDT0 {}
impl WDT0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const wdt0::RegisterBlock = 0x4000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const wdt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WDT0 {
    type Target = wdt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WDT0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WDT0").finish()
    }
}
#[doc = "Watchdog Timers"]
pub mod wdt0;
#[doc = "Watchdog Timers"]
pub struct WDT1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WDT1 {}
impl WDT1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const wdt0::RegisterBlock = 0x4000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const wdt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WDT1 {
    type Target = wdt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WDT1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WDT1").finish()
    }
}
#[doc = "Watchdog Timers"]
pub use wdt0 as wdt1;
#[doc = "General Purpose I/O Ports (GPIO)"]
pub struct GPIO {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIO {}
impl GPIO {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpio::RegisterBlock = 0x4000_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpio::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIO {
    type Target = gpio::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIO {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIO").finish()
    }
}
#[doc = "General Purpose I/O Ports (GPIO)"]
pub mod gpio;
#[doc = "16/32 bit Timer/Counters"]
pub struct TMR0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TMR0 {}
impl TMR0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tmr0::RegisterBlock = 0x4000_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tmr0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TMR0 {
    type Target = tmr0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TMR0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TMR0").finish()
    }
}
#[doc = "16/32 bit Timer/Counters"]
pub mod tmr0;
#[doc = "16/32 bit Timer/Counters"]
pub struct TMR1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TMR1 {}
impl TMR1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tmr0::RegisterBlock = 0x4000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tmr0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TMR1 {
    type Target = tmr0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TMR1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TMR1").finish()
    }
}
#[doc = "16/32 bit Timer/Counters"]
pub use tmr0 as tmr1;
#[doc = "16/32 bit Timer/Counters"]
pub struct TMR2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TMR2 {}
impl TMR2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tmr0::RegisterBlock = 0x4000_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tmr0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TMR2 {
    type Target = tmr0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TMR2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TMR2").finish()
    }
}
#[doc = "16/32 bit Timer/Counters"]
pub use tmr0 as tmr2;
#[doc = "16/32 bit Timer/Counters"]
pub struct TMR3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TMR3 {}
impl TMR3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tmr0::RegisterBlock = 0x4000_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tmr0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TMR3 {
    type Target = tmr0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TMR3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TMR3").finish()
    }
}
#[doc = "16/32 bit Timer/Counters"]
pub use tmr0 as tmr3;
#[doc = "16/32 bit Timer/Counters"]
pub struct TMR4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TMR4 {}
impl TMR4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tmr0::RegisterBlock = 0x4000_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tmr0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TMR4 {
    type Target = tmr0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TMR4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TMR4").finish()
    }
}
#[doc = "16/32 bit Timer/Counters"]
pub use tmr0 as tmr4;
#[doc = "16/32 bit Timer/Counters"]
pub struct TMR5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TMR5 {}
impl TMR5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tmr0::RegisterBlock = 0x4001_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tmr0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TMR5 {
    type Target = tmr0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TMR5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TMR5").finish()
    }
}
#[doc = "16/32 bit Timer/Counters"]
pub use tmr0 as tmr5;
#[doc = "UART / Serial Port Interface"]
pub struct UART0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART0 {}
impl UART0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x4001_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART0 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART0").finish()
    }
}
#[doc = "UART / Serial Port Interface"]
pub mod uart0;
#[doc = "UART / Serial Port Interface"]
pub struct UART1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART1 {}
impl UART1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x4001_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART1 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART1").finish()
    }
}
#[doc = "UART / Serial Port Interface"]
pub use uart0 as uart1;
#[doc = "UART / Serial Port Interface"]
pub struct UART2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART2 {}
impl UART2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x4001_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART2 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART2").finish()
    }
}
#[doc = "UART / Serial Port Interface"]
pub use uart0 as uart2;
#[doc = "UART / Serial Port Interface"]
pub struct UART3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART3 {}
impl UART3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x4001_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART3 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART3").finish()
    }
}
#[doc = "UART / Serial Port Interface"]
pub use uart0 as uart3;
#[doc = "Pulse Train Generation"]
pub struct PTG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PTG {}
impl PTG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ptg::RegisterBlock = 0x4001_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ptg::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PTG {
    type Target = ptg::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PTG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PTG").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub mod ptg;
#[doc = "Pulse Train Generation"]
pub struct PT0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT0 {}
impl PT0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_1010 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT0 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT0").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub mod pt0;
#[doc = "Pulse Train Generation"]
pub struct PT1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT1 {}
impl PT1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_101c as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT1 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT1").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt1;
#[doc = "Pulse Train Generation"]
pub struct PT2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT2 {}
impl PT2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_1028 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT2 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT2").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt2;
#[doc = "Pulse Train Generation"]
pub struct PT3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT3 {}
impl PT3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_1034 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT3 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT3").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt3;
#[doc = "Pulse Train Generation"]
pub struct PT4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT4 {}
impl PT4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_1040 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT4 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT4").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt4;
#[doc = "Pulse Train Generation"]
pub struct PT5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT5 {}
impl PT5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_104c as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT5 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT5").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt5;
#[doc = "Pulse Train Generation"]
pub struct PT6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT6 {}
impl PT6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_1058 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT6 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT6").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt6;
#[doc = "Pulse Train Generation"]
pub struct PT7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT7 {}
impl PT7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_1064 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT7 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT7").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt7;
#[doc = "Pulse Train Generation"]
pub struct PT8 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT8 {}
impl PT8 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_1070 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT8 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT8 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT8").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt8;
#[doc = "Pulse Train Generation"]
pub struct PT9 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT9 {}
impl PT9 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_107c as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT9 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT9 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT9").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt9;
#[doc = "Pulse Train Generation"]
pub struct PT10 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT10 {}
impl PT10 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_1088 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT10 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT10 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT10").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt10;
#[doc = "Pulse Train Generation"]
pub struct PT11 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT11 {}
impl PT11 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_1094 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT11 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT11 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT11").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt11;
#[doc = "Pulse Train Generation"]
pub struct PT12 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT12 {}
impl PT12 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_10a0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT12 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT12 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT12").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt12;
#[doc = "Pulse Train Generation"]
pub struct PT13 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT13 {}
impl PT13 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_10ac as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT13 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT13 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT13").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt13;
#[doc = "Pulse Train Generation"]
pub struct PT14 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT14 {}
impl PT14 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_10b8 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT14 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT14 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT14").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt14;
#[doc = "Pulse Train Generation"]
pub struct PT15 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PT15 {}
impl PT15 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pt0::RegisterBlock = 0x4001_10c4 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PT15 {
    type Target = pt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PT15 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PT15").finish()
    }
}
#[doc = "Pulse Train Generation"]
pub use pt0 as pt15;
#[doc = "I2C Master 0 Interface"]
pub struct I2CM0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2CM0 {}
impl I2CM0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2cm0::RegisterBlock = 0x4001_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2cm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2CM0 {
    type Target = i2cm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2CM0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2CM0").finish()
    }
}
#[doc = "I2C Master 0 Interface"]
pub mod i2cm0;
#[doc = "I2C Master 0 Interface"]
pub struct I2CM1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2CM1 {}
impl I2CM1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2cm0::RegisterBlock = 0x4001_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2cm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2CM1 {
    type Target = i2cm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2CM1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2CM1").finish()
    }
}
#[doc = "I2C Master 0 Interface"]
pub use i2cm0 as i2cm1;
#[doc = "I2C Master 0 Interface"]
pub struct I2CM2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2CM2 {}
impl I2CM2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2cm0::RegisterBlock = 0x4001_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2cm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2CM2 {
    type Target = i2cm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2CM2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2CM2").finish()
    }
}
#[doc = "I2C Master 0 Interface"]
pub use i2cm0 as i2cm2;
#[doc = "I2C Slave Interface"]
pub struct I2CS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2CS {}
impl I2CS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2cs::RegisterBlock = 0x4001_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2cs::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2CS {
    type Target = i2cs::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2CS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2CS").finish()
    }
}
#[doc = "I2C Slave Interface"]
pub mod i2cs;
#[doc = "SPI Master Interface"]
pub struct SPIM0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIM0 {}
impl SPIM0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spim0::RegisterBlock = 0x4001_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIM0 {
    type Target = spim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIM0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIM0").finish()
    }
}
#[doc = "SPI Master Interface"]
pub mod spim0;
#[doc = "SPI Master Interface"]
pub struct SPIM1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIM1 {}
impl SPIM1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spim0::RegisterBlock = 0x4001_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIM1 {
    type Target = spim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIM1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIM1").finish()
    }
}
#[doc = "SPI Master Interface"]
pub use spim0 as spim1;
#[doc = "SPI Master Interface"]
pub struct SPIM2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIM2 {}
impl SPIM2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spim0::RegisterBlock = 0x4001_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIM2 {
    type Target = spim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIM2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIM2").finish()
    }
}
#[doc = "SPI Master Interface"]
pub use spim0 as spim2;
#[doc = "1-Wire Master Interface"]
pub struct OWM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for OWM {}
impl OWM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const owm::RegisterBlock = 0x4001_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const owm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for OWM {
    type Target = owm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for OWM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("OWM").finish()
    }
}
#[doc = "1-Wire Master Interface"]
pub mod owm;
#[doc = "10-bit Analog to Digital Converter"]
pub struct ADC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ADC {}
impl ADC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const adc::RegisterBlock = 0x4001_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const adc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ADC {
    type Target = adc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ADC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ADC").finish()
    }
}
#[doc = "10-bit Analog to Digital Converter"]
pub mod adc;
#[doc = "SPI Slave Interface"]
pub struct SPIS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIS {}
impl SPIS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spis::RegisterBlock = 0x4002_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spis::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIS {
    type Target = spis::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIS").finish()
    }
}
#[doc = "SPI Slave Interface"]
pub mod spis;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "CLKMAN"]
    pub CLKMAN: CLKMAN,
    #[doc = "PWRMAN"]
    pub PWRMAN: PWRMAN,
    #[doc = "RTCTMR"]
    pub RTCTMR: RTCTMR,
    #[doc = "RTCCFG"]
    pub RTCCFG: RTCCFG,
    #[doc = "PWRSEQ"]
    pub PWRSEQ: PWRSEQ,
    #[doc = "IOMAN"]
    pub IOMAN: IOMAN,
    #[doc = "FLC"]
    pub FLC: FLC,
    #[doc = "ICC"]
    pub ICC: ICC,
    #[doc = "SPIX"]
    pub SPIX: SPIX,
    #[doc = "PMU0"]
    pub PMU0: PMU0,
    #[doc = "PMU1"]
    pub PMU1: PMU1,
    #[doc = "PMU2"]
    pub PMU2: PMU2,
    #[doc = "PMU3"]
    pub PMU3: PMU3,
    #[doc = "PMU4"]
    pub PMU4: PMU4,
    #[doc = "PMU5"]
    pub PMU5: PMU5,
    #[doc = "USB"]
    pub USB: USB,
    #[doc = "CRC"]
    pub CRC: CRC,
    #[doc = "TPU"]
    pub TPU: TPU,
    #[doc = "TPU_TSR"]
    pub TPU_TSR: TPU_TSR,
    #[doc = "AES"]
    pub AES: AES,
    #[doc = "MAA"]
    pub MAA: MAA,
    #[doc = "WDT0"]
    pub WDT0: WDT0,
    #[doc = "WDT1"]
    pub WDT1: WDT1,
    #[doc = "GPIO"]
    pub GPIO: GPIO,
    #[doc = "TMR0"]
    pub TMR0: TMR0,
    #[doc = "TMR1"]
    pub TMR1: TMR1,
    #[doc = "TMR2"]
    pub TMR2: TMR2,
    #[doc = "TMR3"]
    pub TMR3: TMR3,
    #[doc = "TMR4"]
    pub TMR4: TMR4,
    #[doc = "TMR5"]
    pub TMR5: TMR5,
    #[doc = "UART0"]
    pub UART0: UART0,
    #[doc = "UART1"]
    pub UART1: UART1,
    #[doc = "UART2"]
    pub UART2: UART2,
    #[doc = "UART3"]
    pub UART3: UART3,
    #[doc = "PTG"]
    pub PTG: PTG,
    #[doc = "PT0"]
    pub PT0: PT0,
    #[doc = "PT1"]
    pub PT1: PT1,
    #[doc = "PT2"]
    pub PT2: PT2,
    #[doc = "PT3"]
    pub PT3: PT3,
    #[doc = "PT4"]
    pub PT4: PT4,
    #[doc = "PT5"]
    pub PT5: PT5,
    #[doc = "PT6"]
    pub PT6: PT6,
    #[doc = "PT7"]
    pub PT7: PT7,
    #[doc = "PT8"]
    pub PT8: PT8,
    #[doc = "PT9"]
    pub PT9: PT9,
    #[doc = "PT10"]
    pub PT10: PT10,
    #[doc = "PT11"]
    pub PT11: PT11,
    #[doc = "PT12"]
    pub PT12: PT12,
    #[doc = "PT13"]
    pub PT13: PT13,
    #[doc = "PT14"]
    pub PT14: PT14,
    #[doc = "PT15"]
    pub PT15: PT15,
    #[doc = "I2CM0"]
    pub I2CM0: I2CM0,
    #[doc = "I2CM1"]
    pub I2CM1: I2CM1,
    #[doc = "I2CM2"]
    pub I2CM2: I2CM2,
    #[doc = "I2CS"]
    pub I2CS: I2CS,
    #[doc = "SPIM0"]
    pub SPIM0: SPIM0,
    #[doc = "SPIM1"]
    pub SPIM1: SPIM1,
    #[doc = "SPIM2"]
    pub SPIM2: SPIM2,
    #[doc = "OWM"]
    pub OWM: OWM,
    #[doc = "ADC"]
    pub ADC: ADC,
    #[doc = "SPIS"]
    pub SPIS: SPIS,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        cortex_m::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            CLKMAN: CLKMAN {
                _marker: PhantomData,
            },
            PWRMAN: PWRMAN {
                _marker: PhantomData,
            },
            RTCTMR: RTCTMR {
                _marker: PhantomData,
            },
            RTCCFG: RTCCFG {
                _marker: PhantomData,
            },
            PWRSEQ: PWRSEQ {
                _marker: PhantomData,
            },
            IOMAN: IOMAN {
                _marker: PhantomData,
            },
            FLC: FLC {
                _marker: PhantomData,
            },
            ICC: ICC {
                _marker: PhantomData,
            },
            SPIX: SPIX {
                _marker: PhantomData,
            },
            PMU0: PMU0 {
                _marker: PhantomData,
            },
            PMU1: PMU1 {
                _marker: PhantomData,
            },
            PMU2: PMU2 {
                _marker: PhantomData,
            },
            PMU3: PMU3 {
                _marker: PhantomData,
            },
            PMU4: PMU4 {
                _marker: PhantomData,
            },
            PMU5: PMU5 {
                _marker: PhantomData,
            },
            USB: USB {
                _marker: PhantomData,
            },
            CRC: CRC {
                _marker: PhantomData,
            },
            TPU: TPU {
                _marker: PhantomData,
            },
            TPU_TSR: TPU_TSR {
                _marker: PhantomData,
            },
            AES: AES {
                _marker: PhantomData,
            },
            MAA: MAA {
                _marker: PhantomData,
            },
            WDT0: WDT0 {
                _marker: PhantomData,
            },
            WDT1: WDT1 {
                _marker: PhantomData,
            },
            GPIO: GPIO {
                _marker: PhantomData,
            },
            TMR0: TMR0 {
                _marker: PhantomData,
            },
            TMR1: TMR1 {
                _marker: PhantomData,
            },
            TMR2: TMR2 {
                _marker: PhantomData,
            },
            TMR3: TMR3 {
                _marker: PhantomData,
            },
            TMR4: TMR4 {
                _marker: PhantomData,
            },
            TMR5: TMR5 {
                _marker: PhantomData,
            },
            UART0: UART0 {
                _marker: PhantomData,
            },
            UART1: UART1 {
                _marker: PhantomData,
            },
            UART2: UART2 {
                _marker: PhantomData,
            },
            UART3: UART3 {
                _marker: PhantomData,
            },
            PTG: PTG {
                _marker: PhantomData,
            },
            PT0: PT0 {
                _marker: PhantomData,
            },
            PT1: PT1 {
                _marker: PhantomData,
            },
            PT2: PT2 {
                _marker: PhantomData,
            },
            PT3: PT3 {
                _marker: PhantomData,
            },
            PT4: PT4 {
                _marker: PhantomData,
            },
            PT5: PT5 {
                _marker: PhantomData,
            },
            PT6: PT6 {
                _marker: PhantomData,
            },
            PT7: PT7 {
                _marker: PhantomData,
            },
            PT8: PT8 {
                _marker: PhantomData,
            },
            PT9: PT9 {
                _marker: PhantomData,
            },
            PT10: PT10 {
                _marker: PhantomData,
            },
            PT11: PT11 {
                _marker: PhantomData,
            },
            PT12: PT12 {
                _marker: PhantomData,
            },
            PT13: PT13 {
                _marker: PhantomData,
            },
            PT14: PT14 {
                _marker: PhantomData,
            },
            PT15: PT15 {
                _marker: PhantomData,
            },
            I2CM0: I2CM0 {
                _marker: PhantomData,
            },
            I2CM1: I2CM1 {
                _marker: PhantomData,
            },
            I2CM2: I2CM2 {
                _marker: PhantomData,
            },
            I2CS: I2CS {
                _marker: PhantomData,
            },
            SPIM0: SPIM0 {
                _marker: PhantomData,
            },
            SPIM1: SPIM1 {
                _marker: PhantomData,
            },
            SPIM2: SPIM2 {
                _marker: PhantomData,
            },
            OWM: OWM {
                _marker: PhantomData,
            },
            ADC: ADC {
                _marker: PhantomData,
            },
            SPIS: SPIS {
                _marker: PhantomData,
            },
        }
    }
}
