/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */

/// UploadSession : an object containing information used to keep track of a file upload.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct UploadSession {
    /// The unique identifier for the upload.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// The type of the upload.
    #[serde(rename = "type", skip_serializing_if = "Option::is_none")]
    pub _type: Option<Type>,
    /// The time the upload was created in milliseconds.
    #[serde(rename = "create_at", skip_serializing_if = "Option::is_none")]
    pub create_at: Option<i64>,
    /// The ID of the user performing the upload.
    #[serde(rename = "user_id", skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
    /// The ID of the channel to upload to.
    #[serde(rename = "channel_id", skip_serializing_if = "Option::is_none")]
    pub channel_id: Option<String>,
    /// The name of the file to upload.
    #[serde(rename = "filename", skip_serializing_if = "Option::is_none")]
    pub filename: Option<String>,
    /// The size of the file to upload in bytes.
    #[serde(rename = "file_size", skip_serializing_if = "Option::is_none")]
    pub file_size: Option<i64>,
    /// The amount of data uploaded in bytes.
    #[serde(rename = "file_offset", skip_serializing_if = "Option::is_none")]
    pub file_offset: Option<i64>,
}

impl UploadSession {
    /// an object containing information used to keep track of a file upload.
    pub fn new() -> UploadSession {
        UploadSession {
            id: None,
            _type: None,
            create_at: None,
            user_id: None,
            channel_id: None,
            filename: None,
            file_size: None,
            file_offset: None,
        }
    }
}

/// The type of the upload.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Type {
    #[serde(rename = "attachment")]
    Attachment,
    #[serde(rename = "import")]
    Import,
}

impl Default for Type {
    fn default() -> Type {
        Self::Attachment
    }
}

