/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct SharedChannel {
    /// Channel id of the shared channel
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "team_id", skip_serializing_if = "Option::is_none")]
    pub team_id: Option<String>,
    /// Is this the home cluster for the shared channel
    #[serde(rename = "home", skip_serializing_if = "Option::is_none")]
    pub home: Option<bool>,
    /// Is this shared channel shared as read only
    #[serde(rename = "readonly", skip_serializing_if = "Option::is_none")]
    pub readonly: Option<bool>,
    /// Channel name as it is shared (may be different than original channel name)
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// Channel display name as it appears locally
    #[serde(rename = "display_name", skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "purpose", skip_serializing_if = "Option::is_none")]
    pub purpose: Option<String>,
    #[serde(rename = "header", skip_serializing_if = "Option::is_none")]
    pub header: Option<String>,
    /// Id of the user that shared the channel
    #[serde(rename = "creator_id", skip_serializing_if = "Option::is_none")]
    pub creator_id: Option<String>,
    /// Time in milliseconds that the channel was shared
    #[serde(rename = "create_at", skip_serializing_if = "Option::is_none")]
    pub create_at: Option<i64>,
    /// Time in milliseconds that the shared channel record was last updated
    #[serde(rename = "update_at", skip_serializing_if = "Option::is_none")]
    pub update_at: Option<i64>,
    /// Id of the remote cluster where the shared channel is homed
    #[serde(rename = "remote_id", skip_serializing_if = "Option::is_none")]
    pub remote_id: Option<String>,
}

impl SharedChannel {
    pub fn new() -> SharedChannel {
        SharedChannel {
            id: None,
            team_id: None,
            home: None,
            readonly: None,
            name: None,
            display_name: None,
            purpose: None,
            header: None,
            creator_id: None,
            create_at: None,
            update_at: None,
            remote_id: None,
        }
    }
}


