# Rust API client for openapi

There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn).



## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 4.0.0
- Package version: 4.0.0
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `openapi` and add the following to `Cargo.toml` under `[dependencies]`:

```
openapi = { path = "./openapi" }
```

## Documentation for API Endpoints

All URIs are relative to *http://your-mattermost-url.com/api/v4*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**migrate_auth_to_ldap**](docs/AuthenticationApi.md#migrate_auth_to_ldap) | **POST** /users/migrate_auth/ldap | Migrate user accounts authentication type to LDAP.
*AuthenticationApi* | [**migrate_auth_to_saml**](docs/AuthenticationApi.md#migrate_auth_to_saml) | **POST** /users/migrate_auth/saml | Migrate user accounts authentication type to SAML.
*BleveApi* | [**purge_bleve_indexes**](docs/BleveApi.md#purge_bleve_indexes) | **POST** /bleve/purge_indexes | Purge all Bleve indexes
*BotsApi* | [**assign_bot**](docs/BotsApi.md#assign_bot) | **POST** /bots/{bot_user_id}/assign/{user_id} | Assign a bot to a user
*BotsApi* | [**convert_bot_to_user**](docs/BotsApi.md#convert_bot_to_user) | **POST** /bots/{bot_user_id}/convert_to_user | Convert a bot into a user
*BotsApi* | [**convert_user_to_bot**](docs/BotsApi.md#convert_user_to_bot) | **POST** /users/{user_id}/convert_to_bot | Convert a user into a bot
*BotsApi* | [**create_bot**](docs/BotsApi.md#create_bot) | **POST** /bots | Create a bot
*BotsApi* | [**delete_bot_icon_image**](docs/BotsApi.md#delete_bot_icon_image) | **DELETE** /bots/{bot_user_id}/icon | Delete bot's LHS icon image
*BotsApi* | [**disable_bot**](docs/BotsApi.md#disable_bot) | **POST** /bots/{bot_user_id}/disable | Disable a bot
*BotsApi* | [**enable_bot**](docs/BotsApi.md#enable_bot) | **POST** /bots/{bot_user_id}/enable | Enable a bot
*BotsApi* | [**get_bot**](docs/BotsApi.md#get_bot) | **GET** /bots/{bot_user_id} | Get a bot
*BotsApi* | [**get_bot_icon_image**](docs/BotsApi.md#get_bot_icon_image) | **GET** /bots/{bot_user_id}/icon | Get bot's LHS icon
*BotsApi* | [**get_bots**](docs/BotsApi.md#get_bots) | **GET** /bots | Get bots
*BotsApi* | [**patch_bot**](docs/BotsApi.md#patch_bot) | **PUT** /bots/{bot_user_id} | Patch a bot
*BotsApi* | [**set_bot_icon_image**](docs/BotsApi.md#set_bot_icon_image) | **POST** /bots/{bot_user_id}/icon | Set bot's LHS icon image
*BrandApi* | [**delete_brand_image**](docs/BrandApi.md#delete_brand_image) | **DELETE** /brand/image | Delete current brand image
*BrandApi* | [**get_brand_image**](docs/BrandApi.md#get_brand_image) | **GET** /brand/image | Get brand image
*BrandApi* | [**upload_brand_image**](docs/BrandApi.md#upload_brand_image) | **POST** /brand/image | Upload brand image
*ChannelsApi* | [**add_channel_member**](docs/ChannelsApi.md#add_channel_member) | **POST** /channels/{channel_id}/members | Add user to channel
*ChannelsApi* | [**autocomplete_channels_for_team**](docs/ChannelsApi.md#autocomplete_channels_for_team) | **GET** /teams/{team_id}/channels/autocomplete | Autocomplete channels
*ChannelsApi* | [**autocomplete_channels_for_team_for_search**](docs/ChannelsApi.md#autocomplete_channels_for_team_for_search) | **GET** /teams/{team_id}/channels/search_autocomplete | Autocomplete channels for search
*ChannelsApi* | [**channel_members_minus_group_members**](docs/ChannelsApi.md#channel_members_minus_group_members) | **GET** /channels/{channel_id}/members_minus_group_members | Channel members minus group members.
*ChannelsApi* | [**create_channel**](docs/ChannelsApi.md#create_channel) | **POST** /channels | Create a channel
*ChannelsApi* | [**create_direct_channel**](docs/ChannelsApi.md#create_direct_channel) | **POST** /channels/direct | Create a direct message channel
*ChannelsApi* | [**create_group_channel**](docs/ChannelsApi.md#create_group_channel) | **POST** /channels/group | Create a group message channel
*ChannelsApi* | [**create_sidebar_category_for_team_for_user**](docs/ChannelsApi.md#create_sidebar_category_for_team_for_user) | **POST** /users/{user_id}/teams/{team_id}/channels/categories | Create user's sidebar category
*ChannelsApi* | [**delete_channel**](docs/ChannelsApi.md#delete_channel) | **DELETE** /channels/{channel_id} | Delete a channel
*ChannelsApi* | [**get_all_channels**](docs/ChannelsApi.md#get_all_channels) | **GET** /channels | Get a list of all channels
*ChannelsApi* | [**get_channel**](docs/ChannelsApi.md#get_channel) | **GET** /channels/{channel_id} | Get a channel
*ChannelsApi* | [**get_channel_by_name**](docs/ChannelsApi.md#get_channel_by_name) | **GET** /teams/{team_id}/channels/name/{channel_name} | Get a channel by name
*ChannelsApi* | [**get_channel_by_name_for_team_name**](docs/ChannelsApi.md#get_channel_by_name_for_team_name) | **GET** /teams/name/{team_name}/channels/name/{channel_name} | Get a channel by name and team name
*ChannelsApi* | [**get_channel_member**](docs/ChannelsApi.md#get_channel_member) | **GET** /channels/{channel_id}/members/{user_id} | Get channel member
*ChannelsApi* | [**get_channel_member_counts_by_group**](docs/ChannelsApi.md#get_channel_member_counts_by_group) | **GET** /channels/{channel_id}/member_counts_by_group | Channel members counts for each group that has atleast one member in the channel
*ChannelsApi* | [**get_channel_members**](docs/ChannelsApi.md#get_channel_members) | **GET** /channels/{channel_id}/members | Get channel members
*ChannelsApi* | [**get_channel_members_by_ids**](docs/ChannelsApi.md#get_channel_members_by_ids) | **POST** /channels/{channel_id}/members/ids | Get channel members by ids
*ChannelsApi* | [**get_channel_members_for_user**](docs/ChannelsApi.md#get_channel_members_for_user) | **GET** /users/{user_id}/teams/{team_id}/channels/members | Get channel memberships and roles for a user
*ChannelsApi* | [**get_channel_members_timezones**](docs/ChannelsApi.md#get_channel_members_timezones) | **GET** /channels/{channel_id}/timezones | Get timezones in a channel
*ChannelsApi* | [**get_channel_moderations**](docs/ChannelsApi.md#get_channel_moderations) | **GET** /channels/{channel_id}/moderations | Get information about channel's moderation.
*ChannelsApi* | [**get_channel_stats**](docs/ChannelsApi.md#get_channel_stats) | **GET** /channels/{channel_id}/stats | Get channel statistics
*ChannelsApi* | [**get_channel_unread**](docs/ChannelsApi.md#get_channel_unread) | **GET** /users/{user_id}/channels/{channel_id}/unread | Get unread messages
*ChannelsApi* | [**get_channels_for_team_for_user**](docs/ChannelsApi.md#get_channels_for_team_for_user) | **GET** /users/{user_id}/teams/{team_id}/channels | Get channels for user
*ChannelsApi* | [**get_channels_for_user**](docs/ChannelsApi.md#get_channels_for_user) | **GET** /users/{user_id}/channels | Get all channels from all teams
*ChannelsApi* | [**get_deleted_channels_for_team**](docs/ChannelsApi.md#get_deleted_channels_for_team) | **GET** /teams/{team_id}/channels/deleted | Get deleted channels
*ChannelsApi* | [**get_pinned_posts**](docs/ChannelsApi.md#get_pinned_posts) | **GET** /channels/{channel_id}/pinned | Get a channel's pinned posts
*ChannelsApi* | [**get_private_channels_for_team**](docs/ChannelsApi.md#get_private_channels_for_team) | **GET** /teams/{team_id}/channels/private | Get private channels
*ChannelsApi* | [**get_public_channels_by_ids_for_team**](docs/ChannelsApi.md#get_public_channels_by_ids_for_team) | **POST** /teams/{team_id}/channels/ids | Get a list of channels by ids
*ChannelsApi* | [**get_public_channels_for_team**](docs/ChannelsApi.md#get_public_channels_for_team) | **GET** /teams/{team_id}/channels | Get public channels
*ChannelsApi* | [**get_sidebar_categories_for_team_for_user**](docs/ChannelsApi.md#get_sidebar_categories_for_team_for_user) | **GET** /users/{user_id}/teams/{team_id}/channels/categories | Get user's sidebar categories
*ChannelsApi* | [**get_sidebar_category_for_team_for_user**](docs/ChannelsApi.md#get_sidebar_category_for_team_for_user) | **GET** /users/{user_id}/teams/{team_id}/channels/categories/{category_id} | Get sidebar category
*ChannelsApi* | [**get_sidebar_category_order_for_team_for_user**](docs/ChannelsApi.md#get_sidebar_category_order_for_team_for_user) | **GET** /users/{user_id}/teams/{team_id}/channels/categories/order | Get user's sidebar category order
*ChannelsApi* | [**move_channel**](docs/ChannelsApi.md#move_channel) | **POST** /channels/{channel_id}/move | Move a channel
*ChannelsApi* | [**patch_channel**](docs/ChannelsApi.md#patch_channel) | **PUT** /channels/{channel_id}/patch | Patch a channel
*ChannelsApi* | [**patch_channel_moderations**](docs/ChannelsApi.md#patch_channel_moderations) | **PUT** /channels/{channel_id}/moderations/patch | Update a channel's moderation settings.
*ChannelsApi* | [**remove_sidebar_category_for_team_for_user**](docs/ChannelsApi.md#remove_sidebar_category_for_team_for_user) | **DELETE** /users/{user_id}/teams/{team_id}/channels/categories/{category_id} | Delete sidebar category
*ChannelsApi* | [**remove_user_from_channel**](docs/ChannelsApi.md#remove_user_from_channel) | **DELETE** /channels/{channel_id}/members/{user_id} | Remove user from channel
*ChannelsApi* | [**restore_channel**](docs/ChannelsApi.md#restore_channel) | **POST** /channels/{channel_id}/restore | Restore a channel
*ChannelsApi* | [**search_all_channels**](docs/ChannelsApi.md#search_all_channels) | **POST** /channels/search | Search all private and open type channels across all teams
*ChannelsApi* | [**search_archived_channels**](docs/ChannelsApi.md#search_archived_channels) | **POST** /teams/{team_id}/channels/search_archived | Search archived channels
*ChannelsApi* | [**search_channels**](docs/ChannelsApi.md#search_channels) | **POST** /teams/{team_id}/channels/search | Search channels
*ChannelsApi* | [**search_group_channels**](docs/ChannelsApi.md#search_group_channels) | **POST** /channels/group/search | Search Group Channels
*ChannelsApi* | [**update_channel**](docs/ChannelsApi.md#update_channel) | **PUT** /channels/{channel_id} | Update a channel
*ChannelsApi* | [**update_channel_member_scheme_roles**](docs/ChannelsApi.md#update_channel_member_scheme_roles) | **PUT** /channels/{channel_id}/members/{user_id}/schemeRoles | Update the scheme-derived roles of a channel member.
*ChannelsApi* | [**update_channel_notify_props**](docs/ChannelsApi.md#update_channel_notify_props) | **PUT** /channels/{channel_id}/members/{user_id}/notify_props | Update channel notifications
*ChannelsApi* | [**update_channel_privacy**](docs/ChannelsApi.md#update_channel_privacy) | **PUT** /channels/{channel_id}/privacy | Update channel's privacy
*ChannelsApi* | [**update_channel_roles**](docs/ChannelsApi.md#update_channel_roles) | **PUT** /channels/{channel_id}/members/{user_id}/roles | Update channel roles
*ChannelsApi* | [**update_channel_scheme**](docs/ChannelsApi.md#update_channel_scheme) | **PUT** /channels/{channel_id}/scheme | Set a channel's scheme
*ChannelsApi* | [**update_sidebar_categories_for_team_for_user**](docs/ChannelsApi.md#update_sidebar_categories_for_team_for_user) | **PUT** /users/{user_id}/teams/{team_id}/channels/categories | Update user's sidebar categories
*ChannelsApi* | [**update_sidebar_category_for_team_for_user**](docs/ChannelsApi.md#update_sidebar_category_for_team_for_user) | **PUT** /users/{user_id}/teams/{team_id}/channels/categories/{category_id} | Update sidebar category
*ChannelsApi* | [**update_sidebar_category_order_for_team_for_user**](docs/ChannelsApi.md#update_sidebar_category_order_for_team_for_user) | **PUT** /users/{user_id}/teams/{team_id}/channels/categories/order | Update user's sidebar category order
*ChannelsApi* | [**view_channel**](docs/ChannelsApi.md#view_channel) | **POST** /channels/members/{user_id}/view | View channel
*CloudApi* | [**confirm_customer_payment**](docs/CloudApi.md#confirm_customer_payment) | **POST** /cloud/payment/confirm | Completes the payment setup intent
*CloudApi* | [**create_customer_payment**](docs/CloudApi.md#create_customer_payment) | **POST** /cloud/payment | Create a customer setup payment intent
*CloudApi* | [**get_cloud_customer**](docs/CloudApi.md#get_cloud_customer) | **GET** /cloud/customer | Get cloud customer
*CloudApi* | [**get_cloud_products**](docs/CloudApi.md#get_cloud_products) | **GET** /cloud/products | Get cloud products
*CloudApi* | [**get_invoice_for_subscription_as_pdf**](docs/CloudApi.md#get_invoice_for_subscription_as_pdf) | **GET** /cloud/subscription/invoices/{invoice_id}/pdf | Get cloud invoice PDF
*CloudApi* | [**get_invoices_for_subscription**](docs/CloudApi.md#get_invoices_for_subscription) | **GET** /cloud/subscription/invoices | Get cloud subscription invoices
*CloudApi* | [**get_subscription**](docs/CloudApi.md#get_subscription) | **GET** /cloud/subscription | Get cloud subscription
*CloudApi* | [**get_subscription_stats**](docs/CloudApi.md#get_subscription_stats) | **GET** /cloud/subscription/stats | GET endpoint for cloud subscription stats
*CloudApi* | [**post_endpoint_for_cws_webhooks**](docs/CloudApi.md#post_endpoint_for_cws_webhooks) | **POST** /cloud/webhook | POST endpoint for CWS Webhooks
*CloudApi* | [**send_admin_upgrade_request_email**](docs/CloudApi.md#send_admin_upgrade_request_email) | **POST** /cloud/subscription/limitreached/invite | POST endpoint for triggering sending emails to admin with request to upgrade workspace
*CloudApi* | [**send_admin_upgrade_request_email_on_join**](docs/CloudApi.md#send_admin_upgrade_request_email_on_join) | **POST** /cloud/subscription/limitreached/join | POST endpoint for triggering sending emails to admin with request to upgrade workspace
*CloudApi* | [**update_cloud_customer**](docs/CloudApi.md#update_cloud_customer) | **PUT** /cloud/customer | Update cloud customer
*CloudApi* | [**update_cloud_customer_address**](docs/CloudApi.md#update_cloud_customer_address) | **PUT** /cloud/customer/address | Update cloud customer address
*ClusterApi* | [**get_cluster_status**](docs/ClusterApi.md#get_cluster_status) | **GET** /cluster/status | Get cluster status
*CommandsApi* | [**create_command**](docs/CommandsApi.md#create_command) | **POST** /commands | Create a command
*CommandsApi* | [**delete_command**](docs/CommandsApi.md#delete_command) | **DELETE** /commands/{command_id} | Delete a command
*CommandsApi* | [**execute_command**](docs/CommandsApi.md#execute_command) | **POST** /commands/execute | Execute a command
*CommandsApi* | [**get_command_by_id**](docs/CommandsApi.md#get_command_by_id) | **GET** /commands/{command_id} | Get a command
*CommandsApi* | [**list_autocomplete_commands**](docs/CommandsApi.md#list_autocomplete_commands) | **GET** /teams/{team_id}/commands/autocomplete | List autocomplete commands
*CommandsApi* | [**list_command_autocomplete_suggestions**](docs/CommandsApi.md#list_command_autocomplete_suggestions) | **GET** /teams/{team_id}/commands/autocomplete_suggestions | List commands' autocomplete data
*CommandsApi* | [**list_commands**](docs/CommandsApi.md#list_commands) | **GET** /commands | List commands for a team
*CommandsApi* | [**move_command**](docs/CommandsApi.md#move_command) | **PUT** /commands/{command_id}/move | Move a command
*CommandsApi* | [**regen_command_token**](docs/CommandsApi.md#regen_command_token) | **PUT** /commands/{command_id}/regen_token | Generate a new token
*CommandsApi* | [**update_command**](docs/CommandsApi.md#update_command) | **PUT** /commands/{command_id} | Update a command
*ComplianceApi* | [**create_compliance_report**](docs/ComplianceApi.md#create_compliance_report) | **POST** /compliance/reports | Create report
*ComplianceApi* | [**download_compliance_report**](docs/ComplianceApi.md#download_compliance_report) | **GET** /compliance/reports/{report_id}/download | Download a report
*ComplianceApi* | [**get_compliance_report**](docs/ComplianceApi.md#get_compliance_report) | **GET** /compliance/reports/{report_id} | Get a report
*ComplianceApi* | [**get_compliance_reports**](docs/ComplianceApi.md#get_compliance_reports) | **GET** /compliance/reports | Get reports
*DataRetentionApi* | [**add_channels_to_retention_policy**](docs/DataRetentionApi.md#add_channels_to_retention_policy) | **POST** /data_retention/policies/{policy_id}/channels | Add channels to a granular data retention policy
*DataRetentionApi* | [**add_teams_to_retention_policy**](docs/DataRetentionApi.md#add_teams_to_retention_policy) | **POST** /data_retention/policies/{policy_id}/teams | Add teams to a granular data retention policy
*DataRetentionApi* | [**create_data_retention_policy**](docs/DataRetentionApi.md#create_data_retention_policy) | **POST** /data_retention/policies | Create a new granular data retention policy
*DataRetentionApi* | [**delete_data_retention_policy**](docs/DataRetentionApi.md#delete_data_retention_policy) | **DELETE** /data_retention/policies/{policy_id} | Delete a granular data retention policy
*DataRetentionApi* | [**get_channel_policies_for_user**](docs/DataRetentionApi.md#get_channel_policies_for_user) | **GET** /users/{user_id}/data_retention/channel_policies | Get the policies which are applied to a user's channels
*DataRetentionApi* | [**get_channels_for_retention_policy**](docs/DataRetentionApi.md#get_channels_for_retention_policy) | **GET** /data_retention/policies/{policy_id}/channels | Get the channels for a granular data retention policy
*DataRetentionApi* | [**get_data_retention_policies**](docs/DataRetentionApi.md#get_data_retention_policies) | **GET** /data_retention/policies | Get the granular data retention policies
*DataRetentionApi* | [**get_data_retention_policies_count**](docs/DataRetentionApi.md#get_data_retention_policies_count) | **GET** /data_retention/policies_count | Get the number of granular data retention policies
*DataRetentionApi* | [**get_data_retention_policy**](docs/DataRetentionApi.md#get_data_retention_policy) | **GET** /data_retention/policy | Get the global data retention policy
*DataRetentionApi* | [**get_data_retention_policy_by_id**](docs/DataRetentionApi.md#get_data_retention_policy_by_id) | **GET** /data_retention/policies/{policy_id} | Get a granular data retention policy
*DataRetentionApi* | [**get_team_policies_for_user**](docs/DataRetentionApi.md#get_team_policies_for_user) | **GET** /users/{user_id}/data_retention/team_policies | Get the policies which are applied to a user's teams
*DataRetentionApi* | [**get_teams_for_retention_policy**](docs/DataRetentionApi.md#get_teams_for_retention_policy) | **GET** /data_retention/policies/{policy_id}/teams | Get the teams for a granular data retention policy
*DataRetentionApi* | [**patch_data_retention_policy**](docs/DataRetentionApi.md#patch_data_retention_policy) | **PATCH** /data_retention/policies/{policy_id} | Patch a granular data retention policy
*DataRetentionApi* | [**remove_channels_from_retention_policy**](docs/DataRetentionApi.md#remove_channels_from_retention_policy) | **DELETE** /data_retention/policies/{policy_id}/channels | Delete channels from a granular data retention policy
*DataRetentionApi* | [**remove_teams_from_retention_policy**](docs/DataRetentionApi.md#remove_teams_from_retention_policy) | **DELETE** /data_retention/policies/{policy_id}/teams | Delete teams from a granular data retention policy
*DataRetentionApi* | [**search_channels_for_retention_policy**](docs/DataRetentionApi.md#search_channels_for_retention_policy) | **POST** /data_retention/policies/{policy_id}/channels/search | Search for the channels in a granular data retention policy
*DataRetentionApi* | [**search_teams_for_retention_policy**](docs/DataRetentionApi.md#search_teams_for_retention_policy) | **POST** /data_retention/policies/{policy_id}/teams/search | Search for the teams in a granular data retention policy
*ElasticsearchApi* | [**purge_elasticsearch_indexes**](docs/ElasticsearchApi.md#purge_elasticsearch_indexes) | **POST** /elasticsearch/purge_indexes | Purge all Elasticsearch indexes
*ElasticsearchApi* | [**test_elasticsearch**](docs/ElasticsearchApi.md#test_elasticsearch) | **POST** /elasticsearch/test | Test Elasticsearch configuration
*EmojiApi* | [**autocomplete_emoji**](docs/EmojiApi.md#autocomplete_emoji) | **GET** /emoji/autocomplete | Autocomplete custom emoji
*EmojiApi* | [**create_emoji**](docs/EmojiApi.md#create_emoji) | **POST** /emoji | Create a custom emoji
*EmojiApi* | [**delete_emoji**](docs/EmojiApi.md#delete_emoji) | **DELETE** /emoji/{emoji_id} | Delete a custom emoji
*EmojiApi* | [**get_emoji**](docs/EmojiApi.md#get_emoji) | **GET** /emoji/{emoji_id} | Get a custom emoji
*EmojiApi* | [**get_emoji_by_name**](docs/EmojiApi.md#get_emoji_by_name) | **GET** /emoji/name/{emoji_name} | Get a custom emoji by name
*EmojiApi* | [**get_emoji_image**](docs/EmojiApi.md#get_emoji_image) | **GET** /emoji/{emoji_id}/image | Get custom emoji image
*EmojiApi* | [**get_emoji_list**](docs/EmojiApi.md#get_emoji_list) | **GET** /emoji | Get a list of custom emoji
*EmojiApi* | [**search_emoji**](docs/EmojiApi.md#search_emoji) | **POST** /emoji/search | Search custom emoji
*ExportsApi* | [**delete_export**](docs/ExportsApi.md#delete_export) | **DELETE** /exports/{export_name} | Delete an export file
*ExportsApi* | [**download_export**](docs/ExportsApi.md#download_export) | **GET** /exports/{export_name} | Download an export file
*ExportsApi* | [**list_exports**](docs/ExportsApi.md#list_exports) | **GET** /exports | List export files
*FilesApi* | [**get_file**](docs/FilesApi.md#get_file) | **GET** /files/{file_id} | Get a file
*FilesApi* | [**get_file_info**](docs/FilesApi.md#get_file_info) | **GET** /files/{file_id}/info | Get metadata for a file
*FilesApi* | [**get_file_link**](docs/FilesApi.md#get_file_link) | **GET** /files/{file_id}/link | Get a public file link
*FilesApi* | [**get_file_preview**](docs/FilesApi.md#get_file_preview) | **GET** /files/{file_id}/preview | Get a file's preview
*FilesApi* | [**get_file_public**](docs/FilesApi.md#get_file_public) | **GET** /files/{file_id}/public | Get a public file
*FilesApi* | [**get_file_thumbnail**](docs/FilesApi.md#get_file_thumbnail) | **GET** /files/{file_id}/thumbnail | Get a file's thumbnail
*FilesApi* | [**search_files**](docs/FilesApi.md#search_files) | **POST** /teams/{team_id}/files/search | Search files in a team
*FilesApi* | [**upload_file**](docs/FilesApi.md#upload_file) | **POST** /files | Upload a file
*GroupsApi* | [**add_group_members**](docs/GroupsApi.md#add_group_members) | **POST** /groups/{group_id}/members | Adds members to a custom group
*GroupsApi* | [**create_group**](docs/GroupsApi.md#create_group) | **POST** /groups | Create a custom group
*GroupsApi* | [**delete_group**](docs/GroupsApi.md#delete_group) | **DELETE** /groups/{group_id} | Deletes a custom group
*GroupsApi* | [**delete_group_members**](docs/GroupsApi.md#delete_group_members) | **DELETE** /groups/{group_id}/members | Removes members from a custom group
*GroupsApi* | [**get_group**](docs/GroupsApi.md#get_group) | **GET** /groups/{group_id} | Get a group
*GroupsApi* | [**get_group_stats**](docs/GroupsApi.md#get_group_stats) | **GET** /groups/{group_id}/stats | Get group stats
*GroupsApi* | [**get_group_syncable_for_channel_id**](docs/GroupsApi.md#get_group_syncable_for_channel_id) | **GET** /groups/{group_id}/channels/{channel_id} | Get GroupSyncable from channel ID
*GroupsApi* | [**get_group_syncable_for_team_id**](docs/GroupsApi.md#get_group_syncable_for_team_id) | **GET** /groups/{group_id}/teams/{team_id} | Get GroupSyncable from Team ID
*GroupsApi* | [**get_group_syncables_channels**](docs/GroupsApi.md#get_group_syncables_channels) | **GET** /groups/{group_id}/channels | Get group channels
*GroupsApi* | [**get_group_syncables_teams**](docs/GroupsApi.md#get_group_syncables_teams) | **GET** /groups/{group_id}/teams | Get group teams
*GroupsApi* | [**get_group_users**](docs/GroupsApi.md#get_group_users) | **GET** /groups/{group_id}/members | Get group users
*GroupsApi* | [**get_groups**](docs/GroupsApi.md#get_groups) | **GET** /groups | Get groups
*GroupsApi* | [**get_groups_associated_to_channels_by_team**](docs/GroupsApi.md#get_groups_associated_to_channels_by_team) | **GET** /teams/{team_id}/groups_by_channels | Get team groups by channels
*GroupsApi* | [**get_groups_by_channel**](docs/GroupsApi.md#get_groups_by_channel) | **GET** /channels/{channel_id}/groups | Get channel groups
*GroupsApi* | [**get_groups_by_team**](docs/GroupsApi.md#get_groups_by_team) | **GET** /teams/{team_id}/groups | Get team groups
*GroupsApi* | [**get_groups_by_user_id**](docs/GroupsApi.md#get_groups_by_user_id) | **GET** /users/{user_id}/groups | Get groups for a userId
*GroupsApi* | [**link_group_syncable_for_channel**](docs/GroupsApi.md#link_group_syncable_for_channel) | **POST** /groups/{group_id}/channels/{channel_id}/link | Link a channel to a group
*GroupsApi* | [**link_group_syncable_for_team**](docs/GroupsApi.md#link_group_syncable_for_team) | **POST** /groups/{group_id}/teams/{team_id}/link | Link a team to a group
*GroupsApi* | [**patch_group**](docs/GroupsApi.md#patch_group) | **PUT** /groups/{group_id}/patch | Patch a group
*GroupsApi* | [**patch_group_syncable_for_channel**](docs/GroupsApi.md#patch_group_syncable_for_channel) | **PUT** /groups/{group_id}/channels/{channel_id}/patch | Patch a GroupSyncable associated to Channel
*GroupsApi* | [**patch_group_syncable_for_team**](docs/GroupsApi.md#patch_group_syncable_for_team) | **PUT** /groups/{group_id}/teams/{team_id}/patch | Patch a GroupSyncable associated to Team
*GroupsApi* | [**unlink_group_syncable_for_channel**](docs/GroupsApi.md#unlink_group_syncable_for_channel) | **DELETE** /groups/{group_id}/channels/{channel_id}/link | Delete a link from a channel to a group
*GroupsApi* | [**unlink_group_syncable_for_team**](docs/GroupsApi.md#unlink_group_syncable_for_team) | **DELETE** /groups/{group_id}/teams/{team_id}/link | Delete a link from a team to a group
*GroupsApi* | [**unlink_ldap_group**](docs/GroupsApi.md#unlink_ldap_group) | **DELETE** /ldap/groups/{remote_id}/link | Delete a link for LDAP group
*ImportsApi* | [**list_imports**](docs/ImportsApi.md#list_imports) | **GET** /imports | List import files
*IntegrationActionsApi* | [**open_interactive_dialog**](docs/IntegrationActionsApi.md#open_interactive_dialog) | **POST** /actions/dialogs/open | Open a dialog
*IntegrationActionsApi* | [**submit_interactive_dialog**](docs/IntegrationActionsApi.md#submit_interactive_dialog) | **POST** /actions/dialogs/submit | Submit a dialog
*JobsApi* | [**cancel_job**](docs/JobsApi.md#cancel_job) | **POST** /jobs/{job_id}/cancel | Cancel a job.
*JobsApi* | [**create_job**](docs/JobsApi.md#create_job) | **POST** /jobs | Create a new job.
*JobsApi* | [**download_job**](docs/JobsApi.md#download_job) | **GET** /jobs/{job_id}/download | Download the results of a job.
*JobsApi* | [**get_job**](docs/JobsApi.md#get_job) | **GET** /jobs/{job_id} | Get a job.
*JobsApi* | [**get_jobs**](docs/JobsApi.md#get_jobs) | **GET** /jobs | Get the jobs.
*JobsApi* | [**get_jobs_by_type**](docs/JobsApi.md#get_jobs_by_type) | **GET** /jobs/type/{type} | Get the jobs of the given type.
*LDAPApi* | [**delete_ldap_private_certificate**](docs/LDAPApi.md#delete_ldap_private_certificate) | **DELETE** /ldap/certificate/private | Remove private key
*LDAPApi* | [**delete_ldap_public_certificate**](docs/LDAPApi.md#delete_ldap_public_certificate) | **DELETE** /ldap/certificate/public | Remove public certificate
*LDAPApi* | [**migrate_auth_to_ldap**](docs/LDAPApi.md#migrate_auth_to_ldap) | **POST** /users/migrate_auth/ldap | Migrate user accounts authentication type to LDAP.
*LDAPApi* | [**migrate_id_ldap**](docs/LDAPApi.md#migrate_id_ldap) | **POST** /ldap/migrateid | Migrate Id LDAP
*LDAPApi* | [**sync_ldap**](docs/LDAPApi.md#sync_ldap) | **POST** /ldap/sync | Sync with LDAP
*LDAPApi* | [**test_ldap**](docs/LDAPApi.md#test_ldap) | **POST** /ldap/test | Test LDAP configuration
*LDAPApi* | [**upload_ldap_private_certificate**](docs/LDAPApi.md#upload_ldap_private_certificate) | **POST** /ldap/certificate/private | Upload private key
*LDAPApi* | [**upload_ldap_public_certificate**](docs/LDAPApi.md#upload_ldap_public_certificate) | **POST** /ldap/certificate/public | Upload public certificate
*LdapApi* | [**get_ldap_groups**](docs/LdapApi.md#get_ldap_groups) | **GET** /ldap/groups | Returns a list of LDAP groups
*LdapApi* | [**link_ldap_group**](docs/LdapApi.md#link_ldap_group) | **POST** /ldap/groups/{remote_id}/link | Link a LDAP group
*MigrateApi* | [**migrate_auth_to_ldap**](docs/MigrateApi.md#migrate_auth_to_ldap) | **POST** /users/migrate_auth/ldap | Migrate user accounts authentication type to LDAP.
*MigrateApi* | [**migrate_auth_to_saml**](docs/MigrateApi.md#migrate_auth_to_saml) | **POST** /users/migrate_auth/saml | Migrate user accounts authentication type to SAML.
*OAuthApi* | [**create_o_auth_app**](docs/OAuthApi.md#create_o_auth_app) | **POST** /oauth/apps | Register OAuth app
*OAuthApi* | [**delete_o_auth_app**](docs/OAuthApi.md#delete_o_auth_app) | **DELETE** /oauth/apps/{app_id} | Delete an OAuth app
*OAuthApi* | [**get_authorized_o_auth_apps_for_user**](docs/OAuthApi.md#get_authorized_o_auth_apps_for_user) | **GET** /users/{user_id}/oauth/apps/authorized | Get authorized OAuth apps
*OAuthApi* | [**get_o_auth_app**](docs/OAuthApi.md#get_o_auth_app) | **GET** /oauth/apps/{app_id} | Get an OAuth app
*OAuthApi* | [**get_o_auth_app_info**](docs/OAuthApi.md#get_o_auth_app_info) | **GET** /oauth/apps/{app_id}/info | Get info on an OAuth app
*OAuthApi* | [**get_o_auth_apps**](docs/OAuthApi.md#get_o_auth_apps) | **GET** /oauth/apps | Get OAuth apps
*OAuthApi* | [**regenerate_o_auth_app_secret**](docs/OAuthApi.md#regenerate_o_auth_app_secret) | **POST** /oauth/apps/{app_id}/regen_secret | Regenerate OAuth app secret
*OAuthApi* | [**update_o_auth_app**](docs/OAuthApi.md#update_o_auth_app) | **PUT** /oauth/apps/{app_id} | Update an OAuth app
*OpenGraphApi* | [**open_graph**](docs/OpenGraphApi.md#open_graph) | **POST** /opengraph | Get open graph metadata for url
*PermissionsApi* | [**get_ancillary_permissions**](docs/PermissionsApi.md#get_ancillary_permissions) | **GET** /permissions/ancillary | Return all system console subsection ancillary permissions
*PluginsApi* | [**disable_plugin**](docs/PluginsApi.md#disable_plugin) | **POST** /plugins/{plugin_id}/disable | Disable plugin
*PluginsApi* | [**enable_plugin**](docs/PluginsApi.md#enable_plugin) | **POST** /plugins/{plugin_id}/enable | Enable plugin
*PluginsApi* | [**get_marketplace_plugins**](docs/PluginsApi.md#get_marketplace_plugins) | **GET** /plugins/marketplace | Gets all the marketplace plugins
*PluginsApi* | [**get_marketplace_visited_by_admin**](docs/PluginsApi.md#get_marketplace_visited_by_admin) | **GET** /plugins/marketplace/first_admin_visit | Get if the Plugin Marketplace has been visited by at least an admin.
*PluginsApi* | [**get_plugin_statuses**](docs/PluginsApi.md#get_plugin_statuses) | **GET** /plugins/statuses | Get plugins status
*PluginsApi* | [**get_plugins**](docs/PluginsApi.md#get_plugins) | **GET** /plugins | Get plugins
*PluginsApi* | [**get_webapp_plugins**](docs/PluginsApi.md#get_webapp_plugins) | **GET** /plugins/webapp | Get webapp plugins
*PluginsApi* | [**install_marketplace_plugin**](docs/PluginsApi.md#install_marketplace_plugin) | **POST** /plugins/marketplace | Installs a marketplace plugin
*PluginsApi* | [**install_plugin_from_url**](docs/PluginsApi.md#install_plugin_from_url) | **POST** /plugins/install_from_url | Install plugin from url
*PluginsApi* | [**remove_plugin**](docs/PluginsApi.md#remove_plugin) | **DELETE** /plugins/{plugin_id} | Remove plugin
*PluginsApi* | [**upload_plugin**](docs/PluginsApi.md#upload_plugin) | **POST** /plugins | Upload plugin
*PostsApi* | [**create_post**](docs/PostsApi.md#create_post) | **POST** /posts | Create a post
*PostsApi* | [**create_post_ephemeral**](docs/PostsApi.md#create_post_ephemeral) | **POST** /posts/ephemeral | Create a ephemeral post
*PostsApi* | [**delete_post**](docs/PostsApi.md#delete_post) | **DELETE** /posts/{post_id} | Delete a post
*PostsApi* | [**do_post_action**](docs/PostsApi.md#do_post_action) | **POST** /posts/{post_id}/actions/{action_id} | Perform a post action
*PostsApi* | [**get_file_infos_for_post**](docs/PostsApi.md#get_file_infos_for_post) | **GET** /posts/{post_id}/files/info | Get file info for post
*PostsApi* | [**get_flagged_posts_for_user**](docs/PostsApi.md#get_flagged_posts_for_user) | **GET** /users/{user_id}/posts/flagged | Get a list of flagged posts
*PostsApi* | [**get_post**](docs/PostsApi.md#get_post) | **GET** /posts/{post_id} | Get a post
*PostsApi* | [**get_post_thread**](docs/PostsApi.md#get_post_thread) | **GET** /posts/{post_id}/thread | Get a thread
*PostsApi* | [**get_posts_around_last_unread**](docs/PostsApi.md#get_posts_around_last_unread) | **GET** /users/{user_id}/channels/{channel_id}/posts/unread | Get posts around oldest unread
*PostsApi* | [**get_posts_by_ids**](docs/PostsApi.md#get_posts_by_ids) | **POST** /posts/ids | Get posts by a list of ids
*PostsApi* | [**get_posts_for_channel**](docs/PostsApi.md#get_posts_for_channel) | **GET** /channels/{channel_id}/posts | Get posts for a channel
*PostsApi* | [**patch_post**](docs/PostsApi.md#patch_post) | **PUT** /posts/{post_id}/patch | Patch a post
*PostsApi* | [**pin_post**](docs/PostsApi.md#pin_post) | **POST** /posts/{post_id}/pin | Pin a post to the channel
*PostsApi* | [**search_posts**](docs/PostsApi.md#search_posts) | **POST** /teams/{team_id}/posts/search | Search for team posts
*PostsApi* | [**set_post_unread**](docs/PostsApi.md#set_post_unread) | **POST** /users/{user_id}/posts/{post_id}/set_unread | Mark as unread from a post.
*PostsApi* | [**unpin_post**](docs/PostsApi.md#unpin_post) | **POST** /posts/{post_id}/unpin | Unpin a post to the channel
*PostsApi* | [**update_post**](docs/PostsApi.md#update_post) | **PUT** /posts/{post_id} | Update a post
*PreferencesApi* | [**delete_preferences**](docs/PreferencesApi.md#delete_preferences) | **POST** /users/{user_id}/preferences/delete | Delete user's preferences
*PreferencesApi* | [**get_preferences**](docs/PreferencesApi.md#get_preferences) | **GET** /users/{user_id}/preferences | Get the user's preferences
*PreferencesApi* | [**get_preferences_by_category**](docs/PreferencesApi.md#get_preferences_by_category) | **GET** /users/{user_id}/preferences/{category} | List a user's preferences by category
*PreferencesApi* | [**get_preferences_by_category_by_name**](docs/PreferencesApi.md#get_preferences_by_category_by_name) | **GET** /users/{user_id}/preferences/{category}/name/{preference_name} | Get a specific user preference
*PreferencesApi* | [**update_preferences**](docs/PreferencesApi.md#update_preferences) | **PUT** /users/{user_id}/preferences | Save the user's preferences
*ReactionsApi* | [**delete_reaction**](docs/ReactionsApi.md#delete_reaction) | **DELETE** /users/{user_id}/posts/{post_id}/reactions/{emoji_name} | Remove a reaction from a post
*ReactionsApi* | [**get_bulk_reactions**](docs/ReactionsApi.md#get_bulk_reactions) | **POST** /posts/ids/reactions | Bulk get the reaction for posts
*ReactionsApi* | [**get_reactions**](docs/ReactionsApi.md#get_reactions) | **GET** /posts/{post_id}/reactions | Get a list of reactions to a post
*ReactionsApi* | [**get_top_reactions_for_team**](docs/ReactionsApi.md#get_top_reactions_for_team) | **GET** /teams/{team_id}/top/reactions | Get a list of the top reactions for a team.
*ReactionsApi* | [**get_top_reactions_for_user**](docs/ReactionsApi.md#get_top_reactions_for_user) | **GET** /users/me/top/reactions | Get a list of the top reactions across all public and private channels (the user is a member of) for a given user.
*ReactionsApi* | [**save_reaction**](docs/ReactionsApi.md#save_reaction) | **POST** /reactions | Create a reaction
*RolesApi* | [**get_role**](docs/RolesApi.md#get_role) | **GET** /roles/{role_id} | Get a role
*RolesApi* | [**get_role_by_name**](docs/RolesApi.md#get_role_by_name) | **GET** /roles/name/{role_name} | Get a role
*RolesApi* | [**get_roles_by_names**](docs/RolesApi.md#get_roles_by_names) | **POST** /roles/names | Get a list of roles by name
*RolesApi* | [**patch_role**](docs/RolesApi.md#patch_role) | **PUT** /roles/{role_id}/patch | Patch a role
*RolesApi* | [**roles_get**](docs/RolesApi.md#roles_get) | **GET** /roles | Get a list of all the roles
*RootApi* | [**acknowledge_notification**](docs/RootApi.md#acknowledge_notification) | **POST** /notifications/ack | Acknowledge receiving of a notification
*SAMLApi* | [**delete_saml_idp_certificate**](docs/SAMLApi.md#delete_saml_idp_certificate) | **DELETE** /saml/certificate/idp | Remove IDP certificate
*SAMLApi* | [**delete_saml_private_certificate**](docs/SAMLApi.md#delete_saml_private_certificate) | **DELETE** /saml/certificate/private | Remove private key
*SAMLApi* | [**delete_saml_public_certificate**](docs/SAMLApi.md#delete_saml_public_certificate) | **DELETE** /saml/certificate/public | Remove public certificate
*SAMLApi* | [**get_saml_certificate_status**](docs/SAMLApi.md#get_saml_certificate_status) | **GET** /saml/certificate/status | Get certificate status
*SAMLApi* | [**get_saml_metadata**](docs/SAMLApi.md#get_saml_metadata) | **GET** /saml/metadata | Get metadata
*SAMLApi* | [**get_saml_metadata_from_idp**](docs/SAMLApi.md#get_saml_metadata_from_idp) | **POST** /saml/metadatafromidp | Get metadata from Identity Provider
*SAMLApi* | [**migrate_auth_to_saml**](docs/SAMLApi.md#migrate_auth_to_saml) | **POST** /users/migrate_auth/saml | Migrate user accounts authentication type to SAML.
*SAMLApi* | [**reset_saml_auth_data_to_email**](docs/SAMLApi.md#reset_saml_auth_data_to_email) | **POST** /saml/reset_auth_data | Reset AuthData to Email
*SAMLApi* | [**upload_saml_idp_certificate**](docs/SAMLApi.md#upload_saml_idp_certificate) | **POST** /saml/certificate/idp | Upload IDP certificate
*SAMLApi* | [**upload_saml_private_certificate**](docs/SAMLApi.md#upload_saml_private_certificate) | **POST** /saml/certificate/private | Upload private key
*SAMLApi* | [**upload_saml_public_certificate**](docs/SAMLApi.md#upload_saml_public_certificate) | **POST** /saml/certificate/public | Upload public certificate
*SchemesApi* | [**create_scheme**](docs/SchemesApi.md#create_scheme) | **POST** /schemes | Create a scheme
*SchemesApi* | [**delete_scheme**](docs/SchemesApi.md#delete_scheme) | **DELETE** /schemes/{scheme_id} | Delete a scheme
*SchemesApi* | [**get_channels_for_scheme**](docs/SchemesApi.md#get_channels_for_scheme) | **GET** /schemes/{scheme_id}/channels | Get a page of channels which use this scheme.
*SchemesApi* | [**get_scheme**](docs/SchemesApi.md#get_scheme) | **GET** /schemes/{scheme_id} | Get a scheme
*SchemesApi* | [**get_schemes**](docs/SchemesApi.md#get_schemes) | **GET** /schemes | Get the schemes.
*SchemesApi* | [**get_teams_for_scheme**](docs/SchemesApi.md#get_teams_for_scheme) | **GET** /schemes/{scheme_id}/teams | Get a page of teams which use this scheme.
*SchemesApi* | [**patch_scheme**](docs/SchemesApi.md#patch_scheme) | **PUT** /schemes/{scheme_id}/patch | Patch a scheme
*SearchApi* | [**search_files**](docs/SearchApi.md#search_files) | **POST** /teams/{team_id}/files/search | Search files in a team
*SharedChannelsApi* | [**get_all_shared_channels**](docs/SharedChannelsApi.md#get_all_shared_channels) | **GET** /sharedchannels/{team_id} | Get all shared channels for team.
*SharedChannelsApi* | [**get_remote_cluster_info**](docs/SharedChannelsApi.md#get_remote_cluster_info) | **GET** /sharedchannels/remote_info/{remote_id} | Get remote cluster info by ID for user.
*StatusApi* | [**get_user_status**](docs/StatusApi.md#get_user_status) | **GET** /users/{user_id}/status | Get user status
*StatusApi* | [**get_users_statuses_by_ids**](docs/StatusApi.md#get_users_statuses_by_ids) | **POST** /users/status/ids | Get user statuses by id
*StatusApi* | [**post_user_recent_custom_status_delete**](docs/StatusApi.md#post_user_recent_custom_status_delete) | **POST** /users/{user_id}/status/custom/recent/delete | Delete user's recent custom status
*StatusApi* | [**remove_recent_custom_status**](docs/StatusApi.md#remove_recent_custom_status) | **DELETE** /users/{user_id}/status/custom/recent | Delete user's recent custom status
*StatusApi* | [**unset_user_custom_status**](docs/StatusApi.md#unset_user_custom_status) | **DELETE** /users/{user_id}/status/custom | Unsets user custom status
*StatusApi* | [**update_user_custom_status**](docs/StatusApi.md#update_user_custom_status) | **PUT** /users/{user_id}/status/custom | Update user custom status
*StatusApi* | [**update_user_status**](docs/StatusApi.md#update_user_status) | **PUT** /users/{user_id}/status | Update user status
*SystemApi* | [**check_integrity**](docs/SystemApi.md#check_integrity) | **POST** /integrity | Perform a database integrity check
*SystemApi* | [**clear_server_busy**](docs/SystemApi.md#clear_server_busy) | **DELETE** /server_busy | Clears the server busy (high load) flag
*SystemApi* | [**database_recycle**](docs/SystemApi.md#database_recycle) | **POST** /database/recycle | Recycle database connections
*SystemApi* | [**generate_support_packet**](docs/SystemApi.md#generate_support_packet) | **GET** /system/support_packet | Download a zip file which contains helpful and useful information for troubleshooting your mattermost instance.
*SystemApi* | [**get_analytics_old**](docs/SystemApi.md#get_analytics_old) | **GET** /analytics/old | Get analytics
*SystemApi* | [**get_audits**](docs/SystemApi.md#get_audits) | **GET** /audits | Get audits
*SystemApi* | [**get_client_config**](docs/SystemApi.md#get_client_config) | **GET** /config/client | Get client configuration
*SystemApi* | [**get_client_license**](docs/SystemApi.md#get_client_license) | **GET** /license/client | Get client license
*SystemApi* | [**get_config**](docs/SystemApi.md#get_config) | **GET** /config | Get configuration
*SystemApi* | [**get_environment_config**](docs/SystemApi.md#get_environment_config) | **GET** /config/environment | Get configuration made through environment variables
*SystemApi* | [**get_image_by_url**](docs/SystemApi.md#get_image_by_url) | **GET** /image | Get an image by url
*SystemApi* | [**get_logs**](docs/SystemApi.md#get_logs) | **GET** /logs | Get logs
*SystemApi* | [**get_notices**](docs/SystemApi.md#get_notices) | **GET** /system/notices/{teamId} | Get notices for logged in user in specified team
*SystemApi* | [**get_ping**](docs/SystemApi.md#get_ping) | **GET** /system/ping | Check system health
*SystemApi* | [**get_redirect_location**](docs/SystemApi.md#get_redirect_location) | **GET** /redirect_location | Get redirect location
*SystemApi* | [**get_server_busy_expires**](docs/SystemApi.md#get_server_busy_expires) | **GET** /server_busy | Get server busy expiry time.
*SystemApi* | [**get_supported_timezone**](docs/SystemApi.md#get_supported_timezone) | **GET** /system/timezones | Retrieve a list of supported timezones
*SystemApi* | [**get_warn_metrics_status**](docs/SystemApi.md#get_warn_metrics_status) | **GET** /warn_metrics/status | Get the warn metrics status (enabled or disabled)
*SystemApi* | [**invalidate_caches**](docs/SystemApi.md#invalidate_caches) | **POST** /caches/invalidate | Invalidate all the caches
*SystemApi* | [**mark_notices_viewed**](docs/SystemApi.md#mark_notices_viewed) | **PUT** /system/notices/view | Update notices as 'viewed'
*SystemApi* | [**patch_config**](docs/SystemApi.md#patch_config) | **PUT** /config/patch | Patch configuration
*SystemApi* | [**post_log**](docs/SystemApi.md#post_log) | **POST** /logs | Add log message
*SystemApi* | [**reload_config**](docs/SystemApi.md#reload_config) | **POST** /config/reload | Reload configuration
*SystemApi* | [**remove_license_file**](docs/SystemApi.md#remove_license_file) | **DELETE** /license | Remove license file
*SystemApi* | [**request_license_renewal_link**](docs/SystemApi.md#request_license_renewal_link) | **GET** /license/renewal | Request the license renewal link
*SystemApi* | [**request_trial_license**](docs/SystemApi.md#request_trial_license) | **POST** /trial-license | Request and install a trial license for your server
*SystemApi* | [**restart_server**](docs/SystemApi.md#restart_server) | **POST** /restart | Restart the system after an upgrade from Team Edition to Enterprise Edition
*SystemApi* | [**send_trial_license_warn_metric_ack**](docs/SystemApi.md#send_trial_license_warn_metric_ack) | **POST** /warn_metrics/trial-license-ack/{warn_metric_id} | Request trial license and acknowledge a warning of a metric status
*SystemApi* | [**send_warn_metric_ack**](docs/SystemApi.md#send_warn_metric_ack) | **POST** /warn_metrics/ack/{warn_metric_id} | Acknowledge a warning of a metric status
*SystemApi* | [**set_server_busy**](docs/SystemApi.md#set_server_busy) | **POST** /server_busy | Set the server busy (high load) flag
*SystemApi* | [**test_email**](docs/SystemApi.md#test_email) | **POST** /email/test | Send a test email
*SystemApi* | [**test_s3_connection**](docs/SystemApi.md#test_s3_connection) | **POST** /file/s3_test | Test AWS S3 connection
*SystemApi* | [**test_site_url**](docs/SystemApi.md#test_site_url) | **POST** /site_url/test | Checks the validity of a Site URL
*SystemApi* | [**trial_license_prev_get**](docs/SystemApi.md#trial_license_prev_get) | **GET** /trial-license/prev | Get last trial license used
*SystemApi* | [**update_config**](docs/SystemApi.md#update_config) | **PUT** /config | Update configuration
*SystemApi* | [**update_marketplace_visited_by_admin**](docs/SystemApi.md#update_marketplace_visited_by_admin) | **POST** /plugins/marketplace/first_admin_visit | Stores that the Plugin Marketplace has been visited by at least an admin.
*SystemApi* | [**upgrade_to_enterprise**](docs/SystemApi.md#upgrade_to_enterprise) | **POST** /upgrade_to_enterprise | Executes an inplace upgrade from Team Edition to Enterprise Edition
*SystemApi* | [**upgrade_to_enterprise_status**](docs/SystemApi.md#upgrade_to_enterprise_status) | **GET** /upgrade_to_enterprise/status | Get the current status for the inplace upgrade from Team Edition to Enterprise Edition
*SystemApi* | [**upload_license_file**](docs/SystemApi.md#upload_license_file) | **POST** /license | Upload license file
*TeamsApi* | [**add_team_member**](docs/TeamsApi.md#add_team_member) | **POST** /teams/{team_id}/members | Add user to team
*TeamsApi* | [**add_team_member_from_invite**](docs/TeamsApi.md#add_team_member_from_invite) | **POST** /teams/members/invite | Add user to team from invite
*TeamsApi* | [**add_team_members**](docs/TeamsApi.md#add_team_members) | **POST** /teams/{team_id}/members/batch | Add multiple users to team
*TeamsApi* | [**create_team**](docs/TeamsApi.md#create_team) | **POST** /teams | Create a team
*TeamsApi* | [**get_all_teams**](docs/TeamsApi.md#get_all_teams) | **GET** /teams | Get teams
*TeamsApi* | [**get_team**](docs/TeamsApi.md#get_team) | **GET** /teams/{team_id} | Get a team
*TeamsApi* | [**get_team_by_name**](docs/TeamsApi.md#get_team_by_name) | **GET** /teams/name/{name} | Get a team by name
*TeamsApi* | [**get_team_icon**](docs/TeamsApi.md#get_team_icon) | **GET** /teams/{team_id}/image | Get the team icon
*TeamsApi* | [**get_team_invite_info**](docs/TeamsApi.md#get_team_invite_info) | **GET** /teams/invite/{invite_id} | Get invite info for a team
*TeamsApi* | [**get_team_member**](docs/TeamsApi.md#get_team_member) | **GET** /teams/{team_id}/members/{user_id} | Get a team member
*TeamsApi* | [**get_team_members**](docs/TeamsApi.md#get_team_members) | **GET** /teams/{team_id}/members | Get team members
*TeamsApi* | [**get_team_members_by_ids**](docs/TeamsApi.md#get_team_members_by_ids) | **POST** /teams/{team_id}/members/ids | Get team members by ids
*TeamsApi* | [**get_team_members_for_user**](docs/TeamsApi.md#get_team_members_for_user) | **GET** /users/{user_id}/teams/members | Get team members for a user
*TeamsApi* | [**get_team_stats**](docs/TeamsApi.md#get_team_stats) | **GET** /teams/{team_id}/stats | Get a team stats
*TeamsApi* | [**get_team_unread**](docs/TeamsApi.md#get_team_unread) | **GET** /users/{user_id}/teams/{team_id}/unread | Get unreads for a team
*TeamsApi* | [**get_teams_for_user**](docs/TeamsApi.md#get_teams_for_user) | **GET** /users/{user_id}/teams | Get a user's teams
*TeamsApi* | [**get_teams_unread_for_user**](docs/TeamsApi.md#get_teams_unread_for_user) | **GET** /users/{user_id}/teams/unread | Get team unreads for a user
*TeamsApi* | [**import_team**](docs/TeamsApi.md#import_team) | **POST** /teams/{team_id}/import | Import a Team from other application
*TeamsApi* | [**invalidate_email_invites**](docs/TeamsApi.md#invalidate_email_invites) | **DELETE** /teams/invites/email | Invalidate active email invitations
*TeamsApi* | [**invite_guests_to_team**](docs/TeamsApi.md#invite_guests_to_team) | **POST** /teams/{team_id}/invite-guests/email | Invite guests to the team by email
*TeamsApi* | [**invite_users_to_team**](docs/TeamsApi.md#invite_users_to_team) | **POST** /teams/{team_id}/invite/email | Invite users to the team by email
*TeamsApi* | [**patch_team**](docs/TeamsApi.md#patch_team) | **PUT** /teams/{team_id}/patch | Patch a team
*TeamsApi* | [**regenerate_team_invite_id**](docs/TeamsApi.md#regenerate_team_invite_id) | **POST** /teams/{team_id}/regenerate_invite_id | Regenerate the Invite ID from a Team
*TeamsApi* | [**remove_team_icon**](docs/TeamsApi.md#remove_team_icon) | **DELETE** /teams/{team_id}/image | Remove the team icon
*TeamsApi* | [**remove_team_member**](docs/TeamsApi.md#remove_team_member) | **DELETE** /teams/{team_id}/members/{user_id} | Remove user from team
*TeamsApi* | [**restore_team**](docs/TeamsApi.md#restore_team) | **POST** /teams/{team_id}/restore | Restore a team
*TeamsApi* | [**search_files**](docs/TeamsApi.md#search_files) | **POST** /teams/{team_id}/files/search | Search files in a team
*TeamsApi* | [**search_teams**](docs/TeamsApi.md#search_teams) | **POST** /teams/search | Search teams
*TeamsApi* | [**set_team_icon**](docs/TeamsApi.md#set_team_icon) | **POST** /teams/{team_id}/image | Sets the team icon
*TeamsApi* | [**soft_delete_team**](docs/TeamsApi.md#soft_delete_team) | **DELETE** /teams/{team_id} | Delete a team
*TeamsApi* | [**team_exists**](docs/TeamsApi.md#team_exists) | **GET** /teams/name/{name}/exists | Check if team exists
*TeamsApi* | [**team_members_minus_group_members**](docs/TeamsApi.md#team_members_minus_group_members) | **GET** /teams/{team_id}/members_minus_group_members | Team members minus group members.
*TeamsApi* | [**update_team**](docs/TeamsApi.md#update_team) | **PUT** /teams/{team_id} | Update a team
*TeamsApi* | [**update_team_member_roles**](docs/TeamsApi.md#update_team_member_roles) | **PUT** /teams/{team_id}/members/{user_id}/roles | Update a team member roles
*TeamsApi* | [**update_team_member_scheme_roles**](docs/TeamsApi.md#update_team_member_scheme_roles) | **PUT** /teams/{team_id}/members/{user_id}/schemeRoles | Update the scheme-derived roles of a team member.
*TeamsApi* | [**update_team_privacy**](docs/TeamsApi.md#update_team_privacy) | **PUT** /teams/{team_id}/privacy | Update teams's privacy
*TeamsApi* | [**update_team_scheme**](docs/TeamsApi.md#update_team_scheme) | **PUT** /teams/{team_id}/scheme | Set a team's scheme
*TermsOfServiceApi* | [**create_terms_of_service**](docs/TermsOfServiceApi.md#create_terms_of_service) | **POST** /terms_of_service | Creates a new terms of service
*TermsOfServiceApi* | [**get_terms_of_service**](docs/TermsOfServiceApi.md#get_terms_of_service) | **GET** /terms_of_service | Get latest terms of service
*TermsOfServiceApi* | [**get_user_terms_of_service**](docs/TermsOfServiceApi.md#get_user_terms_of_service) | **GET** /users/{user_id}/terms_of_service | Fetches user's latest terms of service action if the latest action was for acceptance.
*TermsOfServiceApi* | [**register_terms_of_service_action**](docs/TermsOfServiceApi.md#register_terms_of_service_action) | **POST** /users/{user_id}/terms_of_service | Records user action when they accept or decline custom terms of service
*ThreadsApi* | [**get_thread_mention_counts_by_channel**](docs/ThreadsApi.md#get_thread_mention_counts_by_channel) | **GET** /users/{user_id}/teams/{team_id}/threads/mention_counts | Get all unread mention counts from followed threads, per-channel
*ThreadsApi* | [**get_user_thread**](docs/ThreadsApi.md#get_user_thread) | **GET** /users/{user_id}/teams/{team_id}/threads/{thread_id} | Get a thread followed by the user
*ThreadsApi* | [**get_user_threads**](docs/ThreadsApi.md#get_user_threads) | **GET** /users/{user_id}/teams/{team_id}/threads | Get all threads that user is following
*ThreadsApi* | [**start_following_thread**](docs/ThreadsApi.md#start_following_thread) | **PUT** /users/{user_id}/teams/{team_id}/threads/{thread_id}/following | Start following a thread
*ThreadsApi* | [**stop_following_thread**](docs/ThreadsApi.md#stop_following_thread) | **DELETE** /users/{user_id}/teams/{team_id}/threads/{thread_id}/following | Stop following a thread
*ThreadsApi* | [**update_thread_read_for_user**](docs/ThreadsApi.md#update_thread_read_for_user) | **PUT** /users/{user_id}/teams/{team_id}/threads/{thread_id}/read/{timestamp} | Mark a thread that user is following read state to the timestamp
*ThreadsApi* | [**update_threads_read_for_user**](docs/ThreadsApi.md#update_threads_read_for_user) | **PUT** /users/{user_id}/teams/{team_id}/threads/read | Mark all threads that user is following as read
*UploadsApi* | [**create_upload**](docs/UploadsApi.md#create_upload) | **POST** /uploads | Create an upload
*UploadsApi* | [**get_upload**](docs/UploadsApi.md#get_upload) | **GET** /uploads/{upload_id} | Get an upload session
*UploadsApi* | [**upload_data**](docs/UploadsApi.md#upload_data) | **POST** /uploads/{upload_id} | Perform a file upload
*UsersApi* | [**attach_device_id**](docs/UsersApi.md#attach_device_id) | **PUT** /users/sessions/device | Attach mobile device
*UsersApi* | [**autocomplete_users**](docs/UsersApi.md#autocomplete_users) | **GET** /users/autocomplete | Autocomplete users
*UsersApi* | [**check_user_mfa**](docs/UsersApi.md#check_user_mfa) | **POST** /users/mfa | Check MFA
*UsersApi* | [**convert_bot_to_user**](docs/UsersApi.md#convert_bot_to_user) | **POST** /bots/{bot_user_id}/convert_to_user | Convert a bot into a user
*UsersApi* | [**convert_user_to_bot**](docs/UsersApi.md#convert_user_to_bot) | **POST** /users/{user_id}/convert_to_bot | Convert a user into a bot
*UsersApi* | [**create_user**](docs/UsersApi.md#create_user) | **POST** /users | Create a user
*UsersApi* | [**create_user_access_token**](docs/UsersApi.md#create_user_access_token) | **POST** /users/{user_id}/tokens | Create a user access token
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /users/{user_id} | Deactivate a user account.
*UsersApi* | [**demote_user_to_guest**](docs/UsersApi.md#demote_user_to_guest) | **POST** /users/{user_id}/demote | Demote a user to a guest
*UsersApi* | [**disable_user_access_token**](docs/UsersApi.md#disable_user_access_token) | **POST** /users/tokens/disable | Disable personal access token
*UsersApi* | [**enable_user_access_token**](docs/UsersApi.md#enable_user_access_token) | **POST** /users/tokens/enable | Enable personal access token
*UsersApi* | [**generate_mfa_secret**](docs/UsersApi.md#generate_mfa_secret) | **POST** /users/{user_id}/mfa/generate | Generate MFA secret
*UsersApi* | [**get_channel_members_with_team_data_for_user**](docs/UsersApi.md#get_channel_members_with_team_data_for_user) | **GET** /users/{user_id}/channel_members | Get all channel members from all teams for a user
*UsersApi* | [**get_default_profile_image**](docs/UsersApi.md#get_default_profile_image) | **GET** /users/{user_id}/image/default | Return user's default (generated) profile image
*UsersApi* | [**get_known_users**](docs/UsersApi.md#get_known_users) | **GET** /users/known | Get user IDs of known users
*UsersApi* | [**get_profile_image**](docs/UsersApi.md#get_profile_image) | **GET** /users/{user_id}/image | Get user's profile image
*UsersApi* | [**get_sessions**](docs/UsersApi.md#get_sessions) | **GET** /users/{user_id}/sessions | Get user's sessions
*UsersApi* | [**get_total_users_stats**](docs/UsersApi.md#get_total_users_stats) | **GET** /users/stats | Get total count of users in the system
*UsersApi* | [**get_total_users_stats_filtered**](docs/UsersApi.md#get_total_users_stats_filtered) | **GET** /users/stats/filtered | Get total count of users in the system matching the specified filters
*UsersApi* | [**get_uploads_for_user**](docs/UsersApi.md#get_uploads_for_user) | **GET** /users/{user_id}/uploads | Get uploads for a user
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /users/{user_id} | Get a user
*UsersApi* | [**get_user_access_token**](docs/UsersApi.md#get_user_access_token) | **GET** /users/tokens/{token_id} | Get a user access token
*UsersApi* | [**get_user_access_tokens**](docs/UsersApi.md#get_user_access_tokens) | **GET** /users/tokens | Get user access tokens
*UsersApi* | [**get_user_access_tokens_for_user**](docs/UsersApi.md#get_user_access_tokens_for_user) | **GET** /users/{user_id}/tokens | Get user access tokens
*UsersApi* | [**get_user_audits**](docs/UsersApi.md#get_user_audits) | **GET** /users/{user_id}/audits | Get user's audits
*UsersApi* | [**get_user_by_email**](docs/UsersApi.md#get_user_by_email) | **GET** /users/email/{email} | Get a user by email
*UsersApi* | [**get_user_by_username**](docs/UsersApi.md#get_user_by_username) | **GET** /users/username/{username} | Get a user by username
*UsersApi* | [**get_user_terms_of_service**](docs/UsersApi.md#get_user_terms_of_service) | **GET** /users/{user_id}/terms_of_service | Fetches user's latest terms of service action if the latest action was for acceptance.
*UsersApi* | [**get_users**](docs/UsersApi.md#get_users) | **GET** /users | Get users
*UsersApi* | [**get_users_by_group_channel_ids**](docs/UsersApi.md#get_users_by_group_channel_ids) | **POST** /users/group_channels | Get users by group channels ids
*UsersApi* | [**get_users_by_ids**](docs/UsersApi.md#get_users_by_ids) | **POST** /users/ids | Get users by ids
*UsersApi* | [**get_users_by_usernames**](docs/UsersApi.md#get_users_by_usernames) | **POST** /users/usernames | Get users by usernames
*UsersApi* | [**login**](docs/UsersApi.md#login) | **POST** /users/login | Login to Mattermost server
*UsersApi* | [**login_by_cws_token**](docs/UsersApi.md#login_by_cws_token) | **POST** /users/login/cws | Auto-Login to Mattermost server using CWS token
*UsersApi* | [**logout**](docs/UsersApi.md#logout) | **POST** /users/logout | Logout from the Mattermost server
*UsersApi* | [**migrate_auth_to_ldap**](docs/UsersApi.md#migrate_auth_to_ldap) | **POST** /users/migrate_auth/ldap | Migrate user accounts authentication type to LDAP.
*UsersApi* | [**migrate_auth_to_saml**](docs/UsersApi.md#migrate_auth_to_saml) | **POST** /users/migrate_auth/saml | Migrate user accounts authentication type to SAML.
*UsersApi* | [**patch_user**](docs/UsersApi.md#patch_user) | **PUT** /users/{user_id}/patch | Patch a user
*UsersApi* | [**permanent_delete_all_users**](docs/UsersApi.md#permanent_delete_all_users) | **DELETE** /users | Permanent delete all users
*UsersApi* | [**promote_guest_to_user**](docs/UsersApi.md#promote_guest_to_user) | **POST** /users/{user_id}/promote | Promote a guest to user
*UsersApi* | [**publish_user_typing**](docs/UsersApi.md#publish_user_typing) | **POST** /users/{user_id}/typing | Publish a user typing websocket event.
*UsersApi* | [**register_terms_of_service_action**](docs/UsersApi.md#register_terms_of_service_action) | **POST** /users/{user_id}/terms_of_service | Records user action when they accept or decline custom terms of service
*UsersApi* | [**reset_password**](docs/UsersApi.md#reset_password) | **POST** /users/password/reset | Reset password
*UsersApi* | [**revoke_all_sessions**](docs/UsersApi.md#revoke_all_sessions) | **POST** /users/{user_id}/sessions/revoke/all | Revoke all active sessions for a user
*UsersApi* | [**revoke_session**](docs/UsersApi.md#revoke_session) | **POST** /users/{user_id}/sessions/revoke | Revoke a user session
*UsersApi* | [**revoke_sessions_from_all_users**](docs/UsersApi.md#revoke_sessions_from_all_users) | **POST** /users/sessions/revoke/all | Revoke all sessions from all users.
*UsersApi* | [**revoke_user_access_token**](docs/UsersApi.md#revoke_user_access_token) | **POST** /users/tokens/revoke | Revoke a user access token
*UsersApi* | [**search_user_access_tokens**](docs/UsersApi.md#search_user_access_tokens) | **POST** /users/tokens/search | Search tokens
*UsersApi* | [**search_users**](docs/UsersApi.md#search_users) | **POST** /users/search | Search users
*UsersApi* | [**send_password_reset_email**](docs/UsersApi.md#send_password_reset_email) | **POST** /users/password/reset/send | Send password reset email
*UsersApi* | [**send_verification_email**](docs/UsersApi.md#send_verification_email) | **POST** /users/email/verify/send | Send verification email
*UsersApi* | [**set_default_profile_image**](docs/UsersApi.md#set_default_profile_image) | **DELETE** /users/{user_id}/image | Delete user's profile image
*UsersApi* | [**set_profile_image**](docs/UsersApi.md#set_profile_image) | **POST** /users/{user_id}/image | Set user's profile image
*UsersApi* | [**switch_account_type**](docs/UsersApi.md#switch_account_type) | **POST** /users/login/switch | Switch login method
*UsersApi* | [**update_user**](docs/UsersApi.md#update_user) | **PUT** /users/{user_id} | Update a user
*UsersApi* | [**update_user_active**](docs/UsersApi.md#update_user_active) | **PUT** /users/{user_id}/active | Update user active status
*UsersApi* | [**update_user_auth**](docs/UsersApi.md#update_user_auth) | **PUT** /users/{user_id}/auth | Update a user's authentication method
*UsersApi* | [**update_user_mfa**](docs/UsersApi.md#update_user_mfa) | **PUT** /users/{user_id}/mfa | Update a user's MFA
*UsersApi* | [**update_user_password**](docs/UsersApi.md#update_user_password) | **PUT** /users/{user_id}/password | Update a user's password
*UsersApi* | [**update_user_roles**](docs/UsersApi.md#update_user_roles) | **PUT** /users/{user_id}/roles | Update a user's roles
*UsersApi* | [**verify_user_email**](docs/UsersApi.md#verify_user_email) | **POST** /users/email/verify | Verify user email
*UsersApi* | [**verify_user_email_without_token**](docs/UsersApi.md#verify_user_email_without_token) | **POST** /users/{user_id}/email/verify/member | Verify user email by ID
*WebhooksApi* | [**create_incoming_webhook**](docs/WebhooksApi.md#create_incoming_webhook) | **POST** /hooks/incoming | Create an incoming webhook
*WebhooksApi* | [**create_outgoing_webhook**](docs/WebhooksApi.md#create_outgoing_webhook) | **POST** /hooks/outgoing | Create an outgoing webhook
*WebhooksApi* | [**delete_incoming_webhook**](docs/WebhooksApi.md#delete_incoming_webhook) | **DELETE** /hooks/incoming/{hook_id} | Delete an incoming webhook
*WebhooksApi* | [**delete_outgoing_webhook**](docs/WebhooksApi.md#delete_outgoing_webhook) | **DELETE** /hooks/outgoing/{hook_id} | Delete an outgoing webhook
*WebhooksApi* | [**get_incoming_webhook**](docs/WebhooksApi.md#get_incoming_webhook) | **GET** /hooks/incoming/{hook_id} | Get an incoming webhook
*WebhooksApi* | [**get_incoming_webhooks**](docs/WebhooksApi.md#get_incoming_webhooks) | **GET** /hooks/incoming | List incoming webhooks
*WebhooksApi* | [**get_outgoing_webhook**](docs/WebhooksApi.md#get_outgoing_webhook) | **GET** /hooks/outgoing/{hook_id} | Get an outgoing webhook
*WebhooksApi* | [**get_outgoing_webhooks**](docs/WebhooksApi.md#get_outgoing_webhooks) | **GET** /hooks/outgoing | List outgoing webhooks
*WebhooksApi* | [**regen_outgoing_hook_token**](docs/WebhooksApi.md#regen_outgoing_hook_token) | **POST** /hooks/outgoing/{hook_id}/regen_token | Regenerate the token for the outgoing webhook.
*WebhooksApi* | [**update_incoming_webhook**](docs/WebhooksApi.md#update_incoming_webhook) | **PUT** /hooks/incoming/{hook_id} | Update an incoming webhook
*WebhooksApi* | [**update_outgoing_webhook**](docs/WebhooksApi.md#update_outgoing_webhook) | **PUT** /hooks/outgoing/{hook_id} | Update an outgoing webhook


## Documentation For Models

 - [ActionsDialogsOpenDialog](docs/ActionsDialogsOpenDialog.md)
 - [AddOn](docs/AddOn.md)
 - [Address](docs/Address.md)
 - [AppError](docs/AppError.md)
 - [Audit](docs/Audit.md)
 - [AutocompleteSuggestion](docs/AutocompleteSuggestion.md)
 - [Bot](docs/Bot.md)
 - [Channel](docs/Channel.md)
 - [ChannelData](docs/ChannelData.md)
 - [ChannelMember](docs/ChannelMember.md)
 - [ChannelMemberCountByGroup](docs/ChannelMemberCountByGroup.md)
 - [ChannelMemberWithTeamData](docs/ChannelMemberWithTeamData.md)
 - [ChannelMemberWithTeamDataAllOf](docs/ChannelMemberWithTeamDataAllOf.md)
 - [ChannelModeratedRole](docs/ChannelModeratedRole.md)
 - [ChannelModeratedRoles](docs/ChannelModeratedRoles.md)
 - [ChannelModeratedRolesPatch](docs/ChannelModeratedRolesPatch.md)
 - [ChannelModeration](docs/ChannelModeration.md)
 - [ChannelModerationPatch](docs/ChannelModerationPatch.md)
 - [ChannelNotifyProps](docs/ChannelNotifyProps.md)
 - [ChannelStats](docs/ChannelStats.md)
 - [ChannelUnread](docs/ChannelUnread.md)
 - [ChannelUnreadAt](docs/ChannelUnreadAt.md)
 - [ChannelWithTeamData](docs/ChannelWithTeamData.md)
 - [ChannelWithTeamDataAllOf](docs/ChannelWithTeamDataAllOf.md)
 - [CloudCustomer](docs/CloudCustomer.md)
 - [ClusterInfo](docs/ClusterInfo.md)
 - [Command](docs/Command.md)
 - [CommandResponse](docs/CommandResponse.md)
 - [Compliance](docs/Compliance.md)
 - [Config](docs/Config.md)
 - [ConfigAnalyticsSettings](docs/ConfigAnalyticsSettings.md)
 - [ConfigClusterSettings](docs/ConfigClusterSettings.md)
 - [ConfigComplianceSettings](docs/ConfigComplianceSettings.md)
 - [ConfigEmailSettings](docs/ConfigEmailSettings.md)
 - [ConfigFileSettings](docs/ConfigFileSettings.md)
 - [ConfigGitLabSettings](docs/ConfigGitLabSettings.md)
 - [ConfigLdapSettings](docs/ConfigLdapSettings.md)
 - [ConfigLocalizationSettings](docs/ConfigLocalizationSettings.md)
 - [ConfigLogSettings](docs/ConfigLogSettings.md)
 - [ConfigMetricsSettings](docs/ConfigMetricsSettings.md)
 - [ConfigNativeAppSettings](docs/ConfigNativeAppSettings.md)
 - [ConfigPasswordSettings](docs/ConfigPasswordSettings.md)
 - [ConfigPrivacySettings](docs/ConfigPrivacySettings.md)
 - [ConfigRateLimitSettings](docs/ConfigRateLimitSettings.md)
 - [ConfigSamlSettings](docs/ConfigSamlSettings.md)
 - [ConfigServiceSettings](docs/ConfigServiceSettings.md)
 - [ConfigSqlSettings](docs/ConfigSqlSettings.md)
 - [ConfigSupportSettings](docs/ConfigSupportSettings.md)
 - [ConfigTeamSettings](docs/ConfigTeamSettings.md)
 - [DataRetentionPolicy](docs/DataRetentionPolicy.md)
 - [DataRetentionPolicyAllOf](docs/DataRetentionPolicyAllOf.md)
 - [DataRetentionPolicyCreate](docs/DataRetentionPolicyCreate.md)
 - [DataRetentionPolicyForChannel](docs/DataRetentionPolicyForChannel.md)
 - [DataRetentionPolicyForTeam](docs/DataRetentionPolicyForTeam.md)
 - [DataRetentionPolicyWithTeamAndChannelCounts](docs/DataRetentionPolicyWithTeamAndChannelCounts.md)
 - [DataRetentionPolicyWithTeamAndChannelCountsAllOf](docs/DataRetentionPolicyWithTeamAndChannelCountsAllOf.md)
 - [DataRetentionPolicyWithTeamAndChannelIds](docs/DataRetentionPolicyWithTeamAndChannelIds.md)
 - [DataRetentionPolicyWithTeamAndChannelIdsAllOf](docs/DataRetentionPolicyWithTeamAndChannelIdsAllOf.md)
 - [DataRetentionPolicyWithoutId](docs/DataRetentionPolicyWithoutId.md)
 - [Emoji](docs/Emoji.md)
 - [EnvironmentConfig](docs/EnvironmentConfig.md)
 - [EnvironmentConfigAnalyticsSettings](docs/EnvironmentConfigAnalyticsSettings.md)
 - [EnvironmentConfigClusterSettings](docs/EnvironmentConfigClusterSettings.md)
 - [EnvironmentConfigComplianceSettings](docs/EnvironmentConfigComplianceSettings.md)
 - [EnvironmentConfigEmailSettings](docs/EnvironmentConfigEmailSettings.md)
 - [EnvironmentConfigFileSettings](docs/EnvironmentConfigFileSettings.md)
 - [EnvironmentConfigGitLabSettings](docs/EnvironmentConfigGitLabSettings.md)
 - [EnvironmentConfigLdapSettings](docs/EnvironmentConfigLdapSettings.md)
 - [EnvironmentConfigLocalizationSettings](docs/EnvironmentConfigLocalizationSettings.md)
 - [EnvironmentConfigLogSettings](docs/EnvironmentConfigLogSettings.md)
 - [EnvironmentConfigMetricsSettings](docs/EnvironmentConfigMetricsSettings.md)
 - [EnvironmentConfigNativeAppSettings](docs/EnvironmentConfigNativeAppSettings.md)
 - [EnvironmentConfigPasswordSettings](docs/EnvironmentConfigPasswordSettings.md)
 - [EnvironmentConfigRateLimitSettings](docs/EnvironmentConfigRateLimitSettings.md)
 - [EnvironmentConfigSamlSettings](docs/EnvironmentConfigSamlSettings.md)
 - [EnvironmentConfigServiceSettings](docs/EnvironmentConfigServiceSettings.md)
 - [EnvironmentConfigSqlSettings](docs/EnvironmentConfigSqlSettings.md)
 - [EnvironmentConfigSupportSettings](docs/EnvironmentConfigSupportSettings.md)
 - [EnvironmentConfigTeamSettings](docs/EnvironmentConfigTeamSettings.md)
 - [FileInfo](docs/FileInfo.md)
 - [FileInfoList](docs/FileInfoList.md)
 - [GlobalDataRetentionPolicy](docs/GlobalDataRetentionPolicy.md)
 - [Group](docs/Group.md)
 - [GroupSyncableChannel](docs/GroupSyncableChannel.md)
 - [GroupSyncableChannels](docs/GroupSyncableChannels.md)
 - [GroupSyncableTeam](docs/GroupSyncableTeam.md)
 - [GroupSyncableTeams](docs/GroupSyncableTeams.md)
 - [GroupWithSchemeAdmin](docs/GroupWithSchemeAdmin.md)
 - [GroupsGroup](docs/GroupsGroup.md)
 - [IncomingWebhook](docs/IncomingWebhook.md)
 - [InlineObject](docs/InlineObject.md)
 - [InlineObject1](docs/InlineObject1.md)
 - [InlineObject10](docs/InlineObject10.md)
 - [InlineObject101](docs/InlineObject101.md)
 - [InlineObject102](docs/InlineObject102.md)
 - [InlineObject103](docs/InlineObject103.md)
 - [InlineObject104](docs/InlineObject104.md)
 - [InlineObject105](docs/InlineObject105.md)
 - [InlineObject106](docs/InlineObject106.md)
 - [InlineObject107](docs/InlineObject107.md)
 - [InlineObject108](docs/InlineObject108.md)
 - [InlineObject109](docs/InlineObject109.md)
 - [InlineObject11](docs/InlineObject11.md)
 - [InlineObject111](docs/InlineObject111.md)
 - [InlineObject113](docs/InlineObject113.md)
 - [InlineObject12](docs/InlineObject12.md)
 - [InlineObject13](docs/InlineObject13.md)
 - [InlineObject14](docs/InlineObject14.md)
 - [InlineObject15](docs/InlineObject15.md)
 - [InlineObject16](docs/InlineObject16.md)
 - [InlineObject17](docs/InlineObject17.md)
 - [InlineObject18](docs/InlineObject18.md)
 - [InlineObject19](docs/InlineObject19.md)
 - [InlineObject2](docs/InlineObject2.md)
 - [InlineObject20](docs/InlineObject20.md)
 - [InlineObject21](docs/InlineObject21.md)
 - [InlineObject22](docs/InlineObject22.md)
 - [InlineObject23](docs/InlineObject23.md)
 - [InlineObject24](docs/InlineObject24.md)
 - [InlineObject25](docs/InlineObject25.md)
 - [InlineObject26](docs/InlineObject26.md)
 - [InlineObject27](docs/InlineObject27.md)
 - [InlineObject28](docs/InlineObject28.md)
 - [InlineObject29](docs/InlineObject29.md)
 - [InlineObject3](docs/InlineObject3.md)
 - [InlineObject30](docs/InlineObject30.md)
 - [InlineObject31](docs/InlineObject31.md)
 - [InlineObject32](docs/InlineObject32.md)
 - [InlineObject33](docs/InlineObject33.md)
 - [InlineObject34](docs/InlineObject34.md)
 - [InlineObject35](docs/InlineObject35.md)
 - [InlineObject36](docs/InlineObject36.md)
 - [InlineObject37](docs/InlineObject37.md)
 - [InlineObject39](docs/InlineObject39.md)
 - [InlineObject4](docs/InlineObject4.md)
 - [InlineObject40](docs/InlineObject40.md)
 - [InlineObject41](docs/InlineObject41.md)
 - [InlineObject43](docs/InlineObject43.md)
 - [InlineObject44](docs/InlineObject44.md)
 - [InlineObject45](docs/InlineObject45.md)
 - [InlineObject46](docs/InlineObject46.md)
 - [InlineObject47](docs/InlineObject47.md)
 - [InlineObject48](docs/InlineObject48.md)
 - [InlineObject49](docs/InlineObject49.md)
 - [InlineObject5](docs/InlineObject5.md)
 - [InlineObject50](docs/InlineObject50.md)
 - [InlineObject51](docs/InlineObject51.md)
 - [InlineObject52](docs/InlineObject52.md)
 - [InlineObject53](docs/InlineObject53.md)
 - [InlineObject54](docs/InlineObject54.md)
 - [InlineObject55](docs/InlineObject55.md)
 - [InlineObject56](docs/InlineObject56.md)
 - [InlineObject57](docs/InlineObject57.md)
 - [InlineObject58](docs/InlineObject58.md)
 - [InlineObject59](docs/InlineObject59.md)
 - [InlineObject6](docs/InlineObject6.md)
 - [InlineObject60](docs/InlineObject60.md)
 - [InlineObject61](docs/InlineObject61.md)
 - [InlineObject62](docs/InlineObject62.md)
 - [InlineObject65](docs/InlineObject65.md)
 - [InlineObject66](docs/InlineObject66.md)
 - [InlineObject67](docs/InlineObject67.md)
 - [InlineObject69](docs/InlineObject69.md)
 - [InlineObject7](docs/InlineObject7.md)
 - [InlineObject70](docs/InlineObject70.md)
 - [InlineObject71](docs/InlineObject71.md)
 - [InlineObject73](docs/InlineObject73.md)
 - [InlineObject74](docs/InlineObject74.md)
 - [InlineObject75](docs/InlineObject75.md)
 - [InlineObject76](docs/InlineObject76.md)
 - [InlineObject77](docs/InlineObject77.md)
 - [InlineObject78](docs/InlineObject78.md)
 - [InlineObject82](docs/InlineObject82.md)
 - [InlineObject83](docs/InlineObject83.md)
 - [InlineObject86](docs/InlineObject86.md)
 - [InlineObject87](docs/InlineObject87.md)
 - [InlineObject88](docs/InlineObject88.md)
 - [InlineObject89](docs/InlineObject89.md)
 - [InlineObject9](docs/InlineObject9.md)
 - [InlineObject90](docs/InlineObject90.md)
 - [InlineObject91](docs/InlineObject91.md)
 - [InlineObject93](docs/InlineObject93.md)
 - [InlineObject94](docs/InlineObject94.md)
 - [InlineObject95](docs/InlineObject95.md)
 - [InlineObject96](docs/InlineObject96.md)
 - [InlineObject97](docs/InlineObject97.md)
 - [InlineObject98](docs/InlineObject98.md)
 - [InlineObject99](docs/InlineObject99.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse20011](docs/InlineResponse20011.md)
 - [InlineResponse20012](docs/InlineResponse20012.md)
 - [InlineResponse20013](docs/InlineResponse20013.md)
 - [InlineResponse20014](docs/InlineResponse20014.md)
 - [InlineResponse20015](docs/InlineResponse20015.md)
 - [InlineResponse20016](docs/InlineResponse20016.md)
 - [InlineResponse20017](docs/InlineResponse20017.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [InlineResponse201](docs/InlineResponse201.md)
 - [IntegrityCheckResult](docs/IntegrityCheckResult.md)
 - [Invoice](docs/Invoice.md)
 - [InvoiceLineItem](docs/InvoiceLineItem.md)
 - [Job](docs/Job.md)
 - [LdapGroup](docs/LdapGroup.md)
 - [LdapGroupsPaged](docs/LdapGroupsPaged.md)
 - [LicenseRenewalLink](docs/LicenseRenewalLink.md)
 - [MarketplacePlugin](docs/MarketplacePlugin.md)
 - [Notice](docs/Notice.md)
 - [OAuthApp](docs/OAuthApp.md)
 - [OpenGraph](docs/OpenGraph.md)
 - [OpenGraphArticle](docs/OpenGraphArticle.md)
 - [OpenGraphArticleAuthorsInner](docs/OpenGraphArticleAuthorsInner.md)
 - [OpenGraphAudiosInner](docs/OpenGraphAudiosInner.md)
 - [OpenGraphBook](docs/OpenGraphBook.md)
 - [OpenGraphImagesInner](docs/OpenGraphImagesInner.md)
 - [OpenGraphVideosInner](docs/OpenGraphVideosInner.md)
 - [OrderedSidebarCategories](docs/OrderedSidebarCategories.md)
 - [OrphanedRecord](docs/OrphanedRecord.md)
 - [OutgoingWebhook](docs/OutgoingWebhook.md)
 - [PaymentMethod](docs/PaymentMethod.md)
 - [PaymentSetupIntent](docs/PaymentSetupIntent.md)
 - [PluginManifest](docs/PluginManifest.md)
 - [PluginManifestBackend](docs/PluginManifestBackend.md)
 - [PluginManifestServer](docs/PluginManifestServer.md)
 - [PluginManifestServerExecutables](docs/PluginManifestServerExecutables.md)
 - [PluginManifestWebapp](docs/PluginManifestWebapp.md)
 - [PluginStatus](docs/PluginStatus.md)
 - [Post](docs/Post.md)
 - [PostList](docs/PostList.md)
 - [PostListWithSearchMatches](docs/PostListWithSearchMatches.md)
 - [PostMetadata](docs/PostMetadata.md)
 - [PostMetadataEmbedsInner](docs/PostMetadataEmbedsInner.md)
 - [PostMetadataImagesInner](docs/PostMetadataImagesInner.md)
 - [PostsEphemeralPost](docs/PostsEphemeralPost.md)
 - [Preference](docs/Preference.md)
 - [Product](docs/Product.md)
 - [PushNotification](docs/PushNotification.md)
 - [Reaction](docs/Reaction.md)
 - [RelationalIntegrityCheckData](docs/RelationalIntegrityCheckData.md)
 - [RemoteClusterInfo](docs/RemoteClusterInfo.md)
 - [RetentionPolicyForChannelList](docs/RetentionPolicyForChannelList.md)
 - [RetentionPolicyForTeamList](docs/RetentionPolicyForTeamList.md)
 - [Role](docs/Role.md)
 - [SamlCertificateStatus](docs/SamlCertificateStatus.md)
 - [Scheme](docs/Scheme.md)
 - [ServerBusy](docs/ServerBusy.md)
 - [Session](docs/Session.md)
 - [SharedChannel](docs/SharedChannel.md)
 - [SidebarCategory](docs/SidebarCategory.md)
 - [SidebarCategoryWithChannels](docs/SidebarCategoryWithChannels.md)
 - [SlackAttachment](docs/SlackAttachment.md)
 - [SlackAttachmentField](docs/SlackAttachmentField.md)
 - [Status](docs/Status.md)
 - [StatusOk](docs/StatusOk.md)
 - [Subscription](docs/Subscription.md)
 - [SubscriptionStats](docs/SubscriptionStats.md)
 - [System](docs/System.md)
 - [SystemStatusResponse](docs/SystemStatusResponse.md)
 - [Team](docs/Team.md)
 - [TeamExists](docs/TeamExists.md)
 - [TeamMap](docs/TeamMap.md)
 - [TeamMember](docs/TeamMember.md)
 - [TeamStats](docs/TeamStats.md)
 - [TeamUnread](docs/TeamUnread.md)
 - [TermsOfService](docs/TermsOfService.md)
 - [Timezone](docs/Timezone.md)
 - [TopReaction](docs/TopReaction.md)
 - [TopReactionList](docs/TopReactionList.md)
 - [UploadSession](docs/UploadSession.md)
 - [User](docs/User.md)
 - [UserAccessToken](docs/UserAccessToken.md)
 - [UserAccessTokenSanitized](docs/UserAccessTokenSanitized.md)
 - [UserAuthData](docs/UserAuthData.md)
 - [UserAutocomplete](docs/UserAutocomplete.md)
 - [UserAutocompleteInChannel](docs/UserAutocompleteInChannel.md)
 - [UserAutocompleteInTeam](docs/UserAutocompleteInTeam.md)
 - [UserNotifyProps](docs/UserNotifyProps.md)
 - [UserTermsOfService](docs/UserTermsOfService.md)
 - [UserThread](docs/UserThread.md)
 - [UserThreads](docs/UserThreads.md)
 - [UsersStats](docs/UsersStats.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

feedback@mattermost.com

