/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct InlineObject107 {
    /// The URL to send the submitted dialog payload to
    #[serde(rename = "url")]
    pub url: String,
    /// Channel ID the user submitted the dialog from
    #[serde(rename = "channel_id")]
    pub channel_id: String,
    /// Team ID the user submitted the dialog from
    #[serde(rename = "team_id")]
    pub team_id: String,
    /// String map where keys are element names and values are the element input values
    #[serde(rename = "submission")]
    pub submission: serde_json::Value,
    /// Callback ID sent when the dialog was opened
    #[serde(rename = "callback_id", skip_serializing_if = "Option::is_none")]
    pub callback_id: Option<String>,
    /// State sent when the dialog was opened
    #[serde(rename = "state", skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    /// Set to true if the dialog was cancelled
    #[serde(rename = "cancelled", skip_serializing_if = "Option::is_none")]
    pub cancelled: Option<bool>,
}

impl InlineObject107 {
    pub fn new(url: String, channel_id: String, team_id: String, submission: serde_json::Value) -> InlineObject107 {
        InlineObject107 {
            url,
            channel_id,
            team_id,
            submission,
            callback_id: None,
            state: None,
            cancelled: None,
        }
    }
}


