/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct SystemStatusResponse {
    /// Latest Android version supported
    #[serde(rename = "AndroidLatestVersion", skip_serializing_if = "Option::is_none")]
    pub android_latest_version: Option<String>,
    /// Minimum Android version supported
    #[serde(rename = "AndroidMinVersion", skip_serializing_if = "Option::is_none")]
    pub android_min_version: Option<String>,
    /// Latest desktop version supported
    #[serde(rename = "DesktopLatestVersion", skip_serializing_if = "Option::is_none")]
    pub desktop_latest_version: Option<String>,
    /// Minimum desktop version supported
    #[serde(rename = "DesktopMinVersion", skip_serializing_if = "Option::is_none")]
    pub desktop_min_version: Option<String>,
    /// Latest iOS version supported
    #[serde(rename = "IosLatestVersion", skip_serializing_if = "Option::is_none")]
    pub ios_latest_version: Option<String>,
    /// Minimum iOS version supported
    #[serde(rename = "IosMinVersion", skip_serializing_if = "Option::is_none")]
    pub ios_min_version: Option<String>,
    /// Status of database (\"OK\" or \"UNHEALTHY\"). Included when get_server_status parameter set.
    #[serde(rename = "database_status", skip_serializing_if = "Option::is_none")]
    pub database_status: Option<String>,
    /// Status of filestore (\"OK\" or \"UNHEALTHY\"). Included when get_server_status parameter set.
    #[serde(rename = "filestore_status", skip_serializing_if = "Option::is_none")]
    pub filestore_status: Option<String>,
    /// Status of server (\"OK\" or \"UNHEALTHY\"). Included when get_server_status parameter set.
    #[serde(rename = "status", skip_serializing_if = "Option::is_none")]
    pub status: Option<String>,
    /// Whether the device id provided can receive notifications (\"true\", \"false\" or \"unknown\"). Included when device_id parameter set.
    #[serde(rename = "CanReceiveNotifications", skip_serializing_if = "Option::is_none")]
    pub can_receive_notifications: Option<String>,
}

impl SystemStatusResponse {
    pub fn new() -> SystemStatusResponse {
        SystemStatusResponse {
            android_latest_version: None,
            android_min_version: None,
            desktop_latest_version: None,
            desktop_min_version: None,
            ios_latest_version: None,
            ios_min_version: None,
            database_status: None,
            filestore_status: None,
            status: None,
            can_receive_notifications: None,
        }
    }
}


