/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */

/// SidebarCategory : User's sidebar category



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct SidebarCategory {
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "user_id", skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
    #[serde(rename = "team_id", skip_serializing_if = "Option::is_none")]
    pub team_id: Option<String>,
    #[serde(rename = "display_name", skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    #[serde(rename = "type", skip_serializing_if = "Option::is_none")]
    pub _type: Option<Type>,
}

impl SidebarCategory {
    /// User's sidebar category
    pub fn new() -> SidebarCategory {
        SidebarCategory {
            id: None,
            user_id: None,
            team_id: None,
            display_name: None,
            _type: None,
        }
    }
}

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Type {
    #[serde(rename = "channels")]
    Channels,
    #[serde(rename = "custom")]
    Custom,
    #[serde(rename = "direct_messages")]
    DirectMessages,
    #[serde(rename = "favorites")]
    Favorites,
}

impl Default for Type {
    fn default() -> Type {
        Self::Channels
    }
}

