/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */

/// RelationalIntegrityCheckData : an object containing the results of a relational integrity check.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct RelationalIntegrityCheckData {
    /// the name of the parent relation (table).
    #[serde(rename = "parent_name", skip_serializing_if = "Option::is_none")]
    pub parent_name: Option<String>,
    /// the name of the child relation (table).
    #[serde(rename = "child_name", skip_serializing_if = "Option::is_none")]
    pub child_name: Option<String>,
    /// the name of the attribute (column) containing the parent id.
    #[serde(rename = "parent_id_attr", skip_serializing_if = "Option::is_none")]
    pub parent_id_attr: Option<String>,
    /// the name of the attribute (column) containing the child id.
    #[serde(rename = "child_id_attr", skip_serializing_if = "Option::is_none")]
    pub child_id_attr: Option<String>,
    /// the list of orphaned records found.
    #[serde(rename = "records", skip_serializing_if = "Option::is_none")]
    pub records: Option<Vec<crate::models::OrphanedRecord>>,
}

impl RelationalIntegrityCheckData {
    /// an object containing the results of a relational integrity check.
    pub fn new() -> RelationalIntegrityCheckData {
        RelationalIntegrityCheckData {
            parent_name: None,
            child_name: None,
            parent_id_attr: None,
            child_id_attr: None,
            records: None,
        }
    }
}


