/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct PluginStatus {
    /// Globally unique identifier that represents the plugin.
    #[serde(rename = "plugin_id", skip_serializing_if = "Option::is_none")]
    pub plugin_id: Option<String>,
    /// Name of the plugin.
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// Description of what the plugin is and does.
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// Version number of the plugin.
    #[serde(rename = "version", skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    /// ID of the cluster in which plugin is running
    #[serde(rename = "cluster_id", skip_serializing_if = "Option::is_none")]
    pub cluster_id: Option<String>,
    /// Path to the plugin on the server
    #[serde(rename = "plugin_path", skip_serializing_if = "Option::is_none")]
    pub plugin_path: Option<String>,
    /// State of the plugin
    #[serde(rename = "state", skip_serializing_if = "Option::is_none")]
    pub state: Option<State>,
}

impl PluginStatus {
    pub fn new() -> PluginStatus {
        PluginStatus {
            plugin_id: None,
            name: None,
            description: None,
            version: None,
            cluster_id: None,
            plugin_path: None,
            state: None,
        }
    }
}

/// State of the plugin
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum State {
    #[serde(rename = "null")]
    Null
}

impl Default for State {
    fn default() -> State {
        Self::Null
    }
}

