/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct InlineObject75 {
    /// Incoming webhook GUID
    #[serde(rename = "hook_id", skip_serializing_if = "Option::is_none")]
    pub hook_id: Option<String>,
    /// The ID of a public channel or private group that receives the webhook payloads.
    #[serde(rename = "channel_id")]
    pub channel_id: String,
    /// The display name for this incoming webhook
    #[serde(rename = "display_name")]
    pub display_name: String,
    /// The description for this incoming webhook
    #[serde(rename = "description")]
    pub description: String,
    /// The username this incoming webhook will post as.
    #[serde(rename = "username", skip_serializing_if = "Option::is_none")]
    pub username: Option<String>,
    /// The profile picture this incoming webhook will use when posting.
    #[serde(rename = "icon_url", skip_serializing_if = "Option::is_none")]
    pub icon_url: Option<String>,
}

impl InlineObject75 {
    pub fn new(channel_id: String, display_name: String, description: String) -> InlineObject75 {
        InlineObject75 {
            hook_id: None,
            channel_id,
            display_name,
            description,
            username: None,
            icon_url: None,
        }
    }
}


