/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct InlineObject18 {
    /// The service the user currently uses to login
    #[serde(rename = "current_service")]
    pub current_service: String,
    /// The service the user will use to login
    #[serde(rename = "new_service")]
    pub new_service: String,
    /// The email of the user
    #[serde(rename = "email", skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    /// The password used with the current service
    #[serde(rename = "password", skip_serializing_if = "Option::is_none")]
    pub password: Option<String>,
    /// The MFA code of the current service
    #[serde(rename = "mfa_code", skip_serializing_if = "Option::is_none")]
    pub mfa_code: Option<String>,
    /// The LDAP/AD id of the user
    #[serde(rename = "ldap_id", skip_serializing_if = "Option::is_none")]
    pub ldap_id: Option<String>,
}

impl InlineObject18 {
    pub fn new(current_service: String, new_service: String) -> InlineObject18 {
        InlineObject18 {
            current_service,
            new_service,
            email: None,
            password: None,
            mfa_code: None,
            ldap_id: None,
        }
    }
}


