/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */

/// UserThread : a thread that user is following



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct UserThread {
    /// ID of the post that is this thread's root
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// number of replies in this thread
    #[serde(rename = "reply_count", skip_serializing_if = "Option::is_none")]
    pub reply_count: Option<i32>,
    /// timestamp of the last post to this thread
    #[serde(rename = "last_reply_at", skip_serializing_if = "Option::is_none")]
    pub last_reply_at: Option<i64>,
    /// timestamp of the last time the user viewed this thread
    #[serde(rename = "last_viewed_at", skip_serializing_if = "Option::is_none")]
    pub last_viewed_at: Option<i64>,
    /// list of users participating in this thread. only includes IDs unless 'extended' was set to 'true'
    #[serde(rename = "participants", skip_serializing_if = "Option::is_none")]
    pub participants: Option<Vec<crate::models::Post>>,
    #[serde(rename = "post", skip_serializing_if = "Option::is_none")]
    pub post: Option<Box<crate::models::Post>>,
}

impl UserThread {
    /// a thread that user is following
    pub fn new() -> UserThread {
        UserThread {
            id: None,
            reply_count: None,
            last_reply_at: None,
            last_viewed_at: None,
            participants: None,
            post: None,
        }
    }
}


