/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Notice {
    /// Notice ID
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// Does this notice apply only to sysadmins
    #[serde(rename = "sysAdminOnly", skip_serializing_if = "Option::is_none")]
    pub sys_admin_only: Option<bool>,
    /// Does this notice apply only to team admins
    #[serde(rename = "teamAdminOnly", skip_serializing_if = "Option::is_none")]
    pub team_admin_only: Option<bool>,
    /// Optional action to perform on action button click. (defaults to closing the notice)
    #[serde(rename = "action", skip_serializing_if = "Option::is_none")]
    pub action: Option<String>,
    /// Optional action parameter.  Example: {\"action\": \"url\", actionParam: \"/console/some-page\"}
    #[serde(rename = "actionParam", skip_serializing_if = "Option::is_none")]
    pub action_param: Option<String>,
    /// Optional override for the action button text (defaults to OK)
    #[serde(rename = "actionText", skip_serializing_if = "Option::is_none")]
    pub action_text: Option<String>,
    /// Notice content. Use {{Mattermost}} instead of plain text to support white-labeling. Text supports Markdown.
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// URL of image to display
    #[serde(rename = "image", skip_serializing_if = "Option::is_none")]
    pub image: Option<String>,
    /// Notice title. Use {{Mattermost}} instead of plain text to support white-labeling. Text supports Markdown.
    #[serde(rename = "title", skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
}

impl Notice {
    pub fn new() -> Notice {
        Notice {
            id: None,
            sys_admin_only: None,
            team_admin_only: None,
            action: None,
            action_param: None,
            action_text: None,
            description: None,
            image: None,
            title: None,
        }
    }
}


