/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Role {
    /// The unique identifier of the role.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// The unique name of the role, used when assigning roles to users/groups in contexts.
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// The human readable name for the role.
    #[serde(rename = "display_name", skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// A human readable description of the role.
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// A list of the unique names of the permissions this role grants.
    #[serde(rename = "permissions", skip_serializing_if = "Option::is_none")]
    pub permissions: Option<Vec<String>>,
    /// indicates if this role is managed by a scheme (true), or is a custom stand-alone role (false).
    #[serde(rename = "scheme_managed", skip_serializing_if = "Option::is_none")]
    pub scheme_managed: Option<bool>,
}

impl Role {
    pub fn new() -> Role {
        Role {
            id: None,
            name: None,
            display_name: None,
            description: None,
            permissions: None,
            scheme_managed: None,
        }
    }
}


