/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */

/// OpenGraphBook : Book object used in OpenGraph metadata of a webpage, if type is book



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct OpenGraphBook {
    #[serde(rename = "isbn", skip_serializing_if = "Option::is_none")]
    pub isbn: Option<String>,
    #[serde(rename = "release_date", skip_serializing_if = "Option::is_none")]
    pub release_date: Option<String>,
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    #[serde(rename = "authors", skip_serializing_if = "Option::is_none")]
    pub authors: Option<Vec<crate::models::OpenGraphArticleAuthorsInner>>,
}

impl OpenGraphBook {
    /// Book object used in OpenGraph metadata of a webpage, if type is book
    pub fn new() -> OpenGraphBook {
        OpenGraphBook {
            isbn: None,
            release_date: None,
            tags: None,
            authors: None,
        }
    }
}


