/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */

/// OpenGraphArticle : Article object used in OpenGraph metadata of a webpage, if type is article



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct OpenGraphArticle {
    #[serde(rename = "published_time", skip_serializing_if = "Option::is_none")]
    pub published_time: Option<String>,
    #[serde(rename = "modified_time", skip_serializing_if = "Option::is_none")]
    pub modified_time: Option<String>,
    #[serde(rename = "expiration_time", skip_serializing_if = "Option::is_none")]
    pub expiration_time: Option<String>,
    #[serde(rename = "section", skip_serializing_if = "Option::is_none")]
    pub section: Option<String>,
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    #[serde(rename = "authors", skip_serializing_if = "Option::is_none")]
    pub authors: Option<Vec<crate::models::OpenGraphArticleAuthorsInner>>,
}

impl OpenGraphArticle {
    /// Article object used in OpenGraph metadata of a webpage, if type is article
    pub fn new() -> OpenGraphArticle {
        OpenGraphArticle {
            published_time: None,
            modified_time: None,
            expiration_time: None,
            section: None,
            tags: None,
            authors: None,
        }
    }
}


