/*
 * Mattermost API Reference
 *
 * There is also a work-in-progress [Postman API reference](https://documenter.getpostman.com/view/4508214/RW8FERUn). 
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: feedback@mattermost.com
 * Generated by: https://openapi-generator.tech
 */

/// ActionsDialogsOpenDialog : Post object to create



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ActionsDialogsOpenDialog {
    /// Set an ID that will be included when the dialog is submitted
    #[serde(rename = "callback_id", skip_serializing_if = "Option::is_none")]
    pub callback_id: Option<String>,
    /// Title of the dialog
    #[serde(rename = "title")]
    pub title: String,
    /// Markdown formatted introductory paragraph
    #[serde(rename = "introduction_text", skip_serializing_if = "Option::is_none")]
    pub introduction_text: Option<String>,
    /// Input elements, see https://docs.mattermost.com/developer/interactive-dialogs.html#elements
    #[serde(rename = "elements")]
    pub elements: Vec<serde_json::Value>,
    /// Label on the submit button
    #[serde(rename = "submit_label", skip_serializing_if = "Option::is_none")]
    pub submit_label: Option<String>,
    /// Set true to receive payloads when user cancels a dialog
    #[serde(rename = "notify_on_cancel", skip_serializing_if = "Option::is_none")]
    pub notify_on_cancel: Option<bool>,
    /// Set some state to be echoed back with the dialog submission
    #[serde(rename = "state", skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
}

impl ActionsDialogsOpenDialog {
    /// Post object to create
    pub fn new(title: String, elements: Vec<serde_json::Value>) -> ActionsDialogsOpenDialog {
        ActionsDialogsOpenDialog {
            callback_id: None,
            title,
            introduction_text: None,
            elements,
            submit_label: None,
            notify_on_cancel: None,
            state: None,
        }
    }
}


