# matrix_uri

| Coverage | Pipeline |
| ------ | ------ |
| [![coverage report](https://gitlab.com/famedly/company/backend/libraries/matrix_uri/badges/main/coverage.svg)](https://gitlab.com/famedly/company/backend/libraries/matrix_uri/-/commits/main) | [![pipeline status](https://gitlab.com/famedly/company/backend/libraries/matrix_uri/badges/main/pipeline.svg)](https://gitlab.com/famedly/company/backend/libraries/matrix_uri/-/commits/main) |

## Deprecation Notice

Ruma has support for parsing both types of Matrix URIs as of version `0.5.0`, thus this crate is now deprecated.

## Original Description

A crate for building and parsing Matrix URIs according to both the [matrix.to specification](https://matrix.org/docs/spec/appendices#matrix-to-navigation) and also [MSC2312](https://github.com/matrix-org/matrix-doc/pull/2312) (`matrix://`).

Optionally provides conversion to types from [`ruma_identifiers`](https://docs.rs/ruma-identifiers/0.17.4/ruma_identifiers/) with the `ruma` feature

## Usage

### Building

```rust
let uri = crate::MatrixUri::new(
            crate::MatrixId::new(crate::IdType::UserId, String::from("cute:some.url")),
            None,
            None,
            Some(vec![String::from("headpat.services"), String::from("cute.local")]),
            Some(crate::MatrixUriAction::Chat),
        )
        .unwrap();

println!("{} with {}", uri.action().unwrap().to_string(), uri.mxid.to_string()); // `chat with @cute:some.url`
println!("{}", uri.matrix_uri_string()); // `matrix:u/cute%3Asome.url?action=chat&via=headpat.services&via=cute.local`
println!("{}", uri.matrix_to_string()); // `https://matrix.to/#/%40cute%3Asome.url?action=chat&via=headpat.services&via=cute.local`
```

### Parsing

```rust
let uri = matrix_uri::MatrixUri::from_str("matrix:u/her:example.org?action=chat").unwrap();

println!("{} - {:?}", uri.mxid.to_string(), uri.action().unwrap()); // `@her:example.org - Chat`
```

## Docs

Can be viewed from source by running `cargo doc --open`

## Pre-commit usage

1. If not installed, install with your package manager, or `pip install --user pre-commit`
2. Run `pre-commit autoupdate` to update the pre-commit config to use the newest template
3. Run `pre-commit install` to install the pre-commit hooks to your local environment
