#[macro_use] extern crate quote;

extern crate proc_macro;

use proc_macro::TokenStream;

#[proc_macro_attribute]
pub fn runner(attr: TokenStream, item: TokenStream) -> TokenStream {
    let input = syn::parse_macro_input!(item as syn::ItemFn);

    let ret = &input.sig.output;
    let name = &input.sig.ident;
    let inputs = &input.sig.inputs;
    let body = &input.block;
    let attrs = &input.attrs;

    if input.sig.asyncness.is_some() {
        let msg = "marshmallow doesn't support async entry functions";
        return syn::Error::new_spanned(input.sig.fn_token, msg).to_compile_error().into();
    }

    if name == "main" && !inputs.is_empty() {
        let msg = "the main function cannot accept arguments";
        return syn::Error::new_spanned(input.sig.fn_token, msg).to_compile_error().into();
    }

    let result = quote! {
        #(#attrs)*
        fn #name(#inputs) #ret {
            marshmallow_fm::app_runner(|| { #body })
        }
    };

    result.into()
}
