use html5ever::driver;
use html5ever::serialize;
use html5ever::tendril::TendrilSink;
use markup5ever_arcdom::{ArcDom, SerializableHandle};

#[test]
fn from_utf8() {
    let dom = driver::parse_document(ArcDom::default(), Default::default())
        .from_utf8()
        .one("<title>Test".as_bytes());
    let mut serialized = Vec::new();
    let document: SerializableHandle = dom.document.clone().into();
    serialize::serialize(&mut serialized, &document, Default::default()).unwrap();
    assert_eq!(
        String::from_utf8(serialized).unwrap().replace(" ", ""),
        "<html><head><title>Test</title></head><body></body></html>"
    );
}
