use wasm_bindgen::prelude::*;

use crate::grammar::Grammar;
use crate::parser::parse_owned_ast;

/// Parse a Marktwin input
#[wasm_bindgen(js_name = parse)]
pub fn parse(grammar: JsValue, input: String) -> JsValue {
  let grammar: Grammar = grammar.into_serde().unwrap();
  JsValue::from_serde(&parse_owned_ast(&grammar, &input)).unwrap()
}
