pub const SQLITE_OK: i32 = 0;
pub const SQLITE_ERROR: i32 = 1;
pub const SQLITE_INTERNAL: i32 = 2;
pub const SQLITE_PERM: i32 = 3;
pub const SQLITE_ABORT: i32 = 4;
pub const SQLITE_BUSY: i32 = 5;
pub const SQLITE_LOCKED: i32 = 6;
pub const SQLITE_NOMEM: i32 = 7;
pub const SQLITE_READONLY: i32 = 8;
pub const SQLITE_INTERRUPT: i32 = 9;
pub const SQLITE_IOERR: i32 = 10;
pub const SQLITE_CORRUPT: i32 = 11;
pub const SQLITE_NOTFOUND: i32 = 12;
pub const SQLITE_FULL: i32 = 13;
pub const SQLITE_CANTOPEN: i32 = 14;
pub const SQLITE_PROTOCOL: i32 = 15;
pub const SQLITE_EMPTY: i32 = 16;
pub const SQLITE_SCHEMA: i32 = 17;
pub const SQLITE_TOOBIG: i32 = 18;
pub const SQLITE_CONSTRAINT: i32 = 19;
pub const SQLITE_MISMATCH: i32 = 20;
pub const SQLITE_MISUSE: i32 = 21;
pub const SQLITE_NOLFS: i32 = 22;
pub const SQLITE_AUTH: i32 = 23;
pub const SQLITE_FORMAT: i32 = 24;
pub const SQLITE_RANGE: i32 = 25;
pub const SQLITE_NOTADB: i32 = 26;
pub const SQLITE_NOTICE: i32 = 27;
pub const SQLITE_WARNING: i32 = 28;
pub const SQLITE_ROW: i32 = 100;
pub const SQLITE_DONE: i32 = 101;

pub const SQLITE_IOERR_READ: i32 = SQLITE_IOERR | (1 << 8);
pub const SQLITE_IOERR_SHORT_READ: i32 = SQLITE_IOERR | (2 << 8);
pub const SQLITE_IOERR_WRITE: i32 = SQLITE_IOERR | (3 << 8);
pub const SQLITE_IOERR_FSYNC: i32 = SQLITE_IOERR | (4 << 8);
pub const SQLITE_IOERR_DIR_FSYNC: i32 = SQLITE_IOERR | (5 << 8);
pub const SQLITE_IOERR_TRUNCATE: i32 = SQLITE_IOERR | (6 << 8);
pub const SQLITE_IOERR_FSTAT: i32 = SQLITE_IOERR | (7 << 8);
pub const SQLITE_IOERR_UNLOCK: i32 = SQLITE_IOERR | (8 << 8);
pub const SQLITE_IOERR_RDLOCK: i32 = SQLITE_IOERR | (9 << 8);
pub const SQLITE_IOERR_DELETE: i32 = SQLITE_IOERR | (10 << 8);
pub const SQLITE_IOERR_BLOCKED: i32 = SQLITE_IOERR | (11 << 8);
pub const SQLITE_IOERR_NOMEM: i32 = SQLITE_IOERR | (12 << 8);
pub const SQLITE_IOERR_ACCESS: i32 = SQLITE_IOERR | (13 << 8);
pub const SQLITE_IOERR_CHECKRESERVEDLOCK: i32 = SQLITE_IOERR | (14 << 8);
pub const SQLITE_IOERR_LOCK: i32 = SQLITE_IOERR | (15 << 8);
pub const SQLITE_IOERR_CLOSE: i32 = SQLITE_IOERR | (16 << 8);
pub const SQLITE_IOERR_DIR_CLOSE: i32 = SQLITE_IOERR | (17 << 8);
pub const SQLITE_IOERR_SHMOPEN: i32 = SQLITE_IOERR | (18 << 8);
pub const SQLITE_IOERR_SHMSIZE: i32 = SQLITE_IOERR | (19 << 8);
pub const SQLITE_IOERR_SHMLOCK: i32 = SQLITE_IOERR | (20 << 8);
pub const SQLITE_IOERR_SHMMAP: i32 = SQLITE_IOERR | (21 << 8);
pub const SQLITE_IOERR_SEEK: i32 = SQLITE_IOERR | (22 << 8);
pub const SQLITE_IOERR_DELETE_NOENT: i32 = SQLITE_IOERR | (23 << 8);
pub const SQLITE_IOERR_MMAP: i32 = SQLITE_IOERR | (24 << 8);
pub const SQLITE_IOERR_GETTEMPPATH: i32 = SQLITE_IOERR | (25 << 8);
pub const SQLITE_IOERR_CONVPATH: i32 = SQLITE_IOERR | (26 << 8);
pub const SQLITE_LOCKED_SHAREDCACHE: i32 = SQLITE_LOCKED | (1 << 8);
pub const SQLITE_BUSY_RECOVERY: i32 = SQLITE_BUSY | (1 << 8);
pub const SQLITE_BUSY_SNAPSHOT: i32 = SQLITE_BUSY | (2 << 8);
pub const SQLITE_CANTOPEN_NOTEMPDIR: i32 = SQLITE_CANTOPEN | (1 << 8);
pub const SQLITE_CANTOPEN_ISDIR: i32 = SQLITE_CANTOPEN | (2 << 8);
pub const SQLITE_CANTOPEN_FULLPATH: i32 = SQLITE_CANTOPEN | (3 << 8);
pub const SQLITE_CANTOPEN_CONVPATH: i32 = SQLITE_CANTOPEN | (4 << 8);
pub const SQLITE_CORRUPT_VTAB: i32 = SQLITE_CORRUPT | (1 << 8);
pub const SQLITE_READONLY_RECOVERY: i32 = SQLITE_READONLY | (1 << 8);
pub const SQLITE_READONLY_CANTLOCK: i32 = SQLITE_READONLY | (2 << 8);
pub const SQLITE_READONLY_ROLLBACK: i32 = SQLITE_READONLY | (3 << 8);
pub const SQLITE_READONLY_DBMOVED: i32 = SQLITE_READONLY | (4 << 8);
pub const SQLITE_ABORT_ROLLBACK: i32 = SQLITE_ABORT | (2 << 8);
pub const SQLITE_CONSTRAINT_CHECK: i32 = SQLITE_CONSTRAINT | (1 << 8);
pub const SQLITE_CONSTRAINT_COMMITHOOK: i32 = SQLITE_CONSTRAINT | (2 << 8);
pub const SQLITE_CONSTRAINT_FOREIGNKEY: i32 = SQLITE_CONSTRAINT | (3 << 8);
pub const SQLITE_CONSTRAINT_FUNCTION: i32 = SQLITE_CONSTRAINT | (4 << 8);
pub const SQLITE_CONSTRAINT_NOTNULL: i32 = SQLITE_CONSTRAINT | (5 << 8);
pub const SQLITE_CONSTRAINT_PRIMARYKEY: i32 = SQLITE_CONSTRAINT | (6 << 8);
pub const SQLITE_CONSTRAINT_TRIGGER: i32 = SQLITE_CONSTRAINT | (7 << 8);
pub const SQLITE_CONSTRAINT_UNIQUE: i32 = SQLITE_CONSTRAINT | (8 << 8);
pub const SQLITE_CONSTRAINT_VTAB: i32 = SQLITE_CONSTRAINT | (9 << 8);
pub const SQLITE_CONSTRAINT_ROWID: i32 = SQLITE_CONSTRAINT | (10 << 8);
pub const SQLITE_NOTICE_RECOVER_WAL: i32 = SQLITE_NOTICE | (1 << 8);
pub const SQLITE_NOTICE_RECOVER_ROLLBACK: i32 = SQLITE_NOTICE | (2 << 8);
pub const SQLITE_WARNING_AUTOINDEX: i32 = SQLITE_WARNING | (1 << 8);
pub const SQLITE_AUTH_USER: i32 = SQLITE_AUTH | (1 << 8);
pub const SQLITE_OK_LOAD_PERMANENTLY: i32 = SQLITE_OK | (1 << 8);

pub const SQLITE_OPEN_READONLY: i32 = 0x00000001;
pub const SQLITE_OPEN_READWRITE: i32 = 0x00000002;
pub const SQLITE_OPEN_CREATE: i32 = 0x00000004;
pub const SQLITE_OPEN_DELETEONCLOSE: i32 = 0x00000008;
pub const SQLITE_OPEN_EXCLUSIVE: i32 = 0x00000010;
pub const SQLITE_OPEN_AUTOPROXY: i32 = 0x00000020;
pub const SQLITE_OPEN_URI: i32 = 0x00000040;
pub const SQLITE_OPEN_MEMORY: i32 = 0x00000080;
pub const SQLITE_OPEN_MAIN_DB: i32 = 0x00000100;
pub const SQLITE_OPEN_TEMP_DB: i32 = 0x00000200;
pub const SQLITE_OPEN_TRANSIENT_DB: i32 = 0x00000400;
pub const SQLITE_OPEN_MAIN_JOURNAL: i32 = 0x00000800;
pub const SQLITE_OPEN_TEMP_JOURNAL: i32 = 0x00001000;
pub const SQLITE_OPEN_SUBJOURNAL: i32 = 0x00002000;
pub const SQLITE_OPEN_MASTER_JOURNAL: i32 = 0x00004000;
pub const SQLITE_OPEN_NOMUTEX: i32 = 0x00008000;
pub const SQLITE_OPEN_FULLMUTEX: i32 = 0x00010000;
pub const SQLITE_OPEN_SHAREDCACHE: i32 = 0x00020000;
pub const SQLITE_OPEN_PRIVATECACHE: i32 = 0x00040000;
pub const SQLITE_OPEN_WAL: i32 = 0x00080000;

pub const SQLITE_IOCAP_ATOMIC: i32 = 0x00000001;
pub const SQLITE_IOCAP_ATOMIC512: i32 = 0x00000002;
pub const SQLITE_IOCAP_ATOMIC1K: i32 = 0x00000004;
pub const SQLITE_IOCAP_ATOMIC2K: i32 = 0x00000008;
pub const SQLITE_IOCAP_ATOMIC4K: i32 = 0x00000010;
pub const SQLITE_IOCAP_ATOMIC8K: i32 = 0x00000020;
pub const SQLITE_IOCAP_ATOMIC16K: i32 = 0x00000040;
pub const SQLITE_IOCAP_ATOMIC32K: i32 = 0x00000080;
pub const SQLITE_IOCAP_ATOMIC64K: i32 = 0x00000100;
pub const SQLITE_IOCAP_SAFE_APPEND: i32 = 0x00000200;
pub const SQLITE_IOCAP_SEQUENTIAL: i32 = 0x00000400;
pub const SQLITE_IOCAP_UNDELETABLE_WHEN_OPEN: i32 = 0x00000800;
pub const SQLITE_IOCAP_POWERSAFE_OVERWRITE: i32 = 0x00001000;
pub const SQLITE_IOCAP_IMMUTABLE: i32 = 0x00002000;

pub const SQLITE_LOCK_NONE: i32 = 0;
pub const SQLITE_LOCK_SHARED: i32 = 1;
pub const SQLITE_LOCK_RESERVED: i32 = 2;
pub const SQLITE_LOCK_PENDING: i32 = 3;
pub const SQLITE_LOCK_EXCLUSIVE: i32 = 4;

pub const SQLITE_SYNC_NORMAL: i32 = 0x00002;
pub const SQLITE_SYNC_FULL: i32 = 0x00003;
pub const SQLITE_SYNC_DATAONLY: i32 = 0x00010;

pub const SQLITE_FCNTL_LOCKSTATE: i32 = 1;
pub const SQLITE_FCNTL_GET_LOCKPROXYFILE: i32 = 2;
pub const SQLITE_FCNTL_SET_LOCKPROXYFILE: i32 = 3;
pub const SQLITE_FCNTL_LAST_ERRNO: i32 = 4;
pub const SQLITE_FCNTL_SIZE_HINT: i32 = 5;
pub const SQLITE_FCNTL_CHUNK_SIZE: i32 = 6;
pub const SQLITE_FCNTL_FILE_POINTER: i32 = 7;
pub const SQLITE_FCNTL_SYNC_OMITTED: i32 = 8;
pub const SQLITE_FCNTL_WIN32_AV_RETRY: i32 = 9;
pub const SQLITE_FCNTL_PERSIST_WAL: i32 = 10;
pub const SQLITE_FCNTL_OVERWRITE: i32 = 11;
pub const SQLITE_FCNTL_VFSNAME: i32 = 12;
pub const SQLITE_FCNTL_POWERSAFE_OVERWRITE: i32 = 13;
pub const SQLITE_FCNTL_PRAGMA: i32 = 14;
pub const SQLITE_FCNTL_BUSYHANDLER: i32 = 15;
pub const SQLITE_FCNTL_TEMPFILENAME: i32 = 16;
pub const SQLITE_FCNTL_MMAP_SIZE: i32 = 18;
pub const SQLITE_FCNTL_TRACE: i32 = 19;
pub const SQLITE_FCNTL_HAS_MOVED: i32 = 20;
pub const SQLITE_FCNTL_SYNC: i32 = 21;
pub const SQLITE_FCNTL_COMMIT_PHASETWO: i32 = 22;
pub const SQLITE_FCNTL_WIN32_SET_HANDLE: i32 = 23;
pub const SQLITE_FCNTL_WAL_BLOCK: i32 = 24;
pub const SQLITE_FCNTL_ZIPVFS: i32 = 25;
pub const SQLITE_FCNTL_RBU: i32 = 26;
pub const SQLITE_FCNTL_VFS_POINTER: i32 = 27;
pub const SQLITE_FCNTL_JOURNAL_POINTER: i32 = 28;
pub const SQLITE_FCNTL_WIN32_GET_HANDLE: i32 = 29;
pub const SQLITE_FCNTL_PDB: i32 = 30;

pub const SQLITE_ACCESS_EXISTS: i32 = 0;
pub const SQLITE_ACCESS_READWRITE: i32 = 1;
pub const SQLITE_ACCESS_READ: i32 = 2;

pub const SQLITE_SHM_UNLOCK: i32 = 1;
pub const SQLITE_SHM_LOCK: i32 = 2;
pub const SQLITE_SHM_SHARED: i32 = 4;
pub const SQLITE_SHM_EXCLUSIVE: i32 = 8;
pub const SQLITE_SHM_NLOCK: i32 = 8;

pub const SQLITE_CONFIG_SINGLETHREAD: i32 = 1;
pub const SQLITE_CONFIG_MULTITHREAD: i32 = 2;
pub const SQLITE_CONFIG_SERIALIZED: i32 = 3;
pub const SQLITE_CONFIG_MALLOC: i32 = 4;
pub const SQLITE_CONFIG_GETMALLOC: i32 = 5;
pub const SQLITE_CONFIG_SCRATCH: i32 = 6;
pub const SQLITE_CONFIG_PAGECACHE: i32 = 7;
pub const SQLITE_CONFIG_HEAP: i32 = 8;
pub const SQLITE_CONFIG_MEMSTATUS: i32 = 9;
pub const SQLITE_CONFIG_MUTEX: i32 = 10;
pub const SQLITE_CONFIG_GETMUTEX: i32 = 11;
pub const SQLITE_CONFIG_LOOKASIDE: i32 = 13;
pub const SQLITE_CONFIG_PCACHE: i32 = 14;
pub const SQLITE_CONFIG_GETPCACHE: i32 = 15;
pub const SQLITE_CONFIG_LOG: i32 = 16;
pub const SQLITE_CONFIG_URI: i32 = 17;
pub const SQLITE_CONFIG_PCACHE2: i32 = 18;
pub const SQLITE_CONFIG_GETPCACHE2: i32 = 19;
pub const SQLITE_CONFIG_COVERING_INDEX_SCAN: i32 = 20;
pub const SQLITE_CONFIG_SQLLOG: i32 = 21;
pub const SQLITE_CONFIG_MMAP_SIZE: i32 = 22;
pub const SQLITE_CONFIG_WIN32_HEAPSIZE: i32 = 23;
pub const SQLITE_CONFIG_PCACHE_HDRSZ: i32 = 24;
pub const SQLITE_CONFIG_PMASZ: i32 = 25;

pub const SQLITE_DBCONFIG_MAINDBNAME: i32 = 1000;
pub const SQLITE_DBCONFIG_LOOKASIDE: i32 = 1001;
pub const SQLITE_DBCONFIG_ENABLE_FKEY: i32 = 1002;
pub const SQLITE_DBCONFIG_ENABLE_TRIGGER: i32 = 1003;
pub const SQLITE_DBCONFIG_ENABLE_FTS3_TOKENIZER: i32 = 1004;
pub const SQLITE_DBCONFIG_ENABLE_LOAD_EXTENSION: i32 = 1005;
pub const SQLITE_DBCONFIG_NO_CKPT_ON_CLOSE: i32 = 1006;

pub const SQLITE_DENY: i32 = 1;
pub const SQLITE_IGNORE: i32 = 2;

pub const SQLITE_CREATE_INDEX: i32 = 1;
pub const SQLITE_CREATE_TABLE: i32 = 2;
pub const SQLITE_CREATE_TEMP_INDEX: i32 = 3;
pub const SQLITE_CREATE_TEMP_TABLE: i32 = 4;
pub const SQLITE_CREATE_TEMP_TRIGGER: i32 = 5;
pub const SQLITE_CREATE_TEMP_VIEW: i32 = 6;
pub const SQLITE_CREATE_TRIGGER: i32 = 7;
pub const SQLITE_CREATE_VIEW: i32 = 8;
pub const SQLITE_DELETE: i32 = 9;
pub const SQLITE_DROP_INDEX: i32 = 10;
pub const SQLITE_DROP_TABLE: i32 = 11;
pub const SQLITE_DROP_TEMP_INDEX: i32 = 12;
pub const SQLITE_DROP_TEMP_TABLE: i32 = 13;
pub const SQLITE_DROP_TEMP_TRIGGER: i32 = 14;
pub const SQLITE_DROP_TEMP_VIEW: i32 = 15;
pub const SQLITE_DROP_TRIGGER: i32 = 16;
pub const SQLITE_DROP_VIEW: i32 = 17;
pub const SQLITE_INSERT: i32 = 18;
pub const SQLITE_PRAGMA: i32 = 19;
pub const SQLITE_READ: i32 = 20;
pub const SQLITE_SELECT: i32 = 21;
pub const SQLITE_TRANSACTION: i32 = 22;
pub const SQLITE_UPDATE: i32 = 23;
pub const SQLITE_ATTACH: i32 = 24;
pub const SQLITE_DETACH: i32 = 25;
pub const SQLITE_ALTER_TABLE: i32 = 26;
pub const SQLITE_REINDEX: i32 = 27;
pub const SQLITE_ANALYZE: i32 = 28;
pub const SQLITE_CREATE_VTABLE: i32 = 29;
pub const SQLITE_DROP_VTABLE: i32 = 30;
pub const SQLITE_FUNCTION: i32 = 31;
pub const SQLITE_SAVEPOINT: i32 = 32;
pub const SQLITE_COPY: i32 = 0;
pub const SQLITE_RECURSIVE: i32 = 33;

pub const SQLITE_TRACE_STMT: i32 = 0x01;
pub const SQLITE_TRACE_PROFILE: i32 = 0x02;
pub const SQLITE_TRACE_ROW: i32 = 0x04;
pub const SQLITE_TRACE_CLOSE: i32 = 0x08;

pub const SQLITE_LIMIT_LENGTH: i32 = 0;
pub const SQLITE_LIMIT_SQL_LENGTH: i32 = 1;
pub const SQLITE_LIMIT_COLUMN: i32 = 2;
pub const SQLITE_LIMIT_EXPR_DEPTH: i32 = 3;
pub const SQLITE_LIMIT_COMPOUND_SELECT: i32 = 4;
pub const SQLITE_LIMIT_VDBE_OP: i32 = 5;
pub const SQLITE_LIMIT_FUNCTION_ARG: i32 = 6;
pub const SQLITE_LIMIT_ATTACHED: i32 = 7;
pub const SQLITE_LIMIT_LIKE_PATTERN_LENGTH: i32 = 8;
pub const SQLITE_LIMIT_VARIABLE_NUMBER: i32 = 9;
pub const SQLITE_LIMIT_TRIGGER_DEPTH: i32 = 10;
pub const SQLITE_LIMIT_WORKER_THREADS: i32 = 11;

pub const SQLITE_INTEGER: i32 = 1;
pub const SQLITE_FLOAT: i32 = 2;
pub const SQLITE_TEXT: i32 = 3;
pub const SQLITE_BLOB: i32 = 4;
pub const SQLITE_NULL: i32 = 5;

pub const SQLITE_UTF8: i32 = 1;
pub const SQLITE_UTF16LE: i32 = 2;
pub const SQLITE_UTF16BE: i32 = 3;
pub const SQLITE_UTF16: i32 = 4;
pub const SQLITE_ANY: i32 = 5;
pub const SQLITE_UTF16_ALIGNED: i32 = 8;

pub const SQLITE_DETERMINISTIC: i32 = 0x800;

pub const SQLITE_STATIC: i32 = 0;
pub const SQLITE_TRANSIENT: i32 = -1;

pub const SQLITE_INDEX_SCAN_UNIQUE: i32 = 1;
pub const SQLITE_INDEX_CONSTRAINT_EQ: i32 = 2;
pub const SQLITE_INDEX_CONSTRAINT_GT: i32 = 4;
pub const SQLITE_INDEX_CONSTRAINT_LE: i32 = 8;
pub const SQLITE_INDEX_CONSTRAINT_LT: i32 = 16;
pub const SQLITE_INDEX_CONSTRAINT_GE: i32 = 32;
pub const SQLITE_INDEX_CONSTRAINT_MATCH: i32 = 64;
pub const SQLITE_INDEX_CONSTRAINT_LIKE: i32 = 65;
pub const SQLITE_INDEX_CONSTRAINT_GLOB: i32 = 66;
pub const SQLITE_INDEX_CONSTRAINT_REGEXP: i32 = 67;

pub const SQLITE_MUTEX_FAST: i32 = 0;
pub const SQLITE_MUTEX_RECURSIVE: i32 = 1;
pub const SQLITE_MUTEX_STATIC_MASTER: i32 = 2;
pub const SQLITE_MUTEX_STATIC_MEM: i32 = 3;
pub const SQLITE_MUTEX_STATIC_MEM2: i32 = 4;
pub const SQLITE_MUTEX_STATIC_OPEN: i32 = 4;
pub const SQLITE_MUTEX_STATIC_PRNG: i32 = 5;
pub const SQLITE_MUTEX_STATIC_LRU: i32 = 6;
pub const SQLITE_MUTEX_STATIC_LRU2: i32 = 7;
pub const SQLITE_MUTEX_STATIC_PMEM: i32 = 7;
pub const SQLITE_MUTEX_STATIC_APP1: i32 = 8;
pub const SQLITE_MUTEX_STATIC_APP2: i32 = 9;
pub const SQLITE_MUTEX_STATIC_APP3: i32 = 10;
pub const SQLITE_MUTEX_STATIC_VFS1: i32 = 11;
pub const SQLITE_MUTEX_STATIC_VFS2: i32 = 12;
pub const SQLITE_MUTEX_STATIC_VFS3: i32 = 13;

pub const SQLITE_TESTCTRL_FIRST: i32 = 5;
pub const SQLITE_TESTCTRL_PRNG_SAVE: i32 = 5;
pub const SQLITE_TESTCTRL_PRNG_RESTORE: i32 = 6;
pub const SQLITE_TESTCTRL_PRNG_RESET: i32 = 7;
pub const SQLITE_TESTCTRL_BITVEC_TEST: i32 = 8;
pub const SQLITE_TESTCTRL_FAULT_INSTALL: i32 = 9;
pub const SQLITE_TESTCTRL_BENIGN_MALLOC_HOOKS: i32 = 10;
pub const SQLITE_TESTCTRL_PENDING_BYTE: i32 = 11;
pub const SQLITE_TESTCTRL_ASSERT: i32 = 12;
pub const SQLITE_TESTCTRL_ALWAYS: i32 = 13;
pub const SQLITE_TESTCTRL_RESERVE: i32 = 14;
pub const SQLITE_TESTCTRL_OPTIMIZATIONS: i32 = 15;
pub const SQLITE_TESTCTRL_ISKEYWORD: i32 = 16;
pub const SQLITE_TESTCTRL_SCRATCHMALLOC: i32 = 17;
pub const SQLITE_TESTCTRL_LOCALTIME_FAULT: i32 = 18;
pub const SQLITE_TESTCTRL_EXPLAIN_STMT: i32 = 19;
pub const SQLITE_TESTCTRL_ONCE_RESET_THRESHOLD: i32 = 19;
pub const SQLITE_TESTCTRL_NEVER_CORRUPT: i32 = 20;
pub const SQLITE_TESTCTRL_VDBE_COVERAGE: i32 = 21;
pub const SQLITE_TESTCTRL_BYTEORDER: i32 = 22;
pub const SQLITE_TESTCTRL_ISINIT: i32 = 23;
pub const SQLITE_TESTCTRL_SORTER_MMAP: i32 = 24;
pub const SQLITE_TESTCTRL_IMPOSTER: i32 = 25;
pub const SQLITE_TESTCTRL_LAST: i32 = 25;

pub const SQLITE_STATUS_MEMORY_USED: i32 = 0;
pub const SQLITE_STATUS_PAGECACHE_USED: i32 = 1;
pub const SQLITE_STATUS_PAGECACHE_OVERFLOW: i32 = 2;
pub const SQLITE_STATUS_SCRATCH_USED: i32 = 3;
pub const SQLITE_STATUS_SCRATCH_OVERFLOW: i32 = 4;
pub const SQLITE_STATUS_MALLOC_SIZE: i32 = 5;
pub const SQLITE_STATUS_PARSER_STACK: i32 = 6;
pub const SQLITE_STATUS_PAGECACHE_SIZE: i32 = 7;
pub const SQLITE_STATUS_SCRATCH_SIZE: i32 = 8;
pub const SQLITE_STATUS_MALLOC_COUNT: i32 = 9;

pub const SQLITE_DBSTATUS_LOOKASIDE_USED: i32 = 0;
pub const SQLITE_DBSTATUS_CACHE_USED: i32 = 1;
pub const SQLITE_DBSTATUS_SCHEMA_USED: i32 = 2;
pub const SQLITE_DBSTATUS_STMT_USED: i32 = 3;
pub const SQLITE_DBSTATUS_LOOKASIDE_HIT: i32 = 4;
pub const SQLITE_DBSTATUS_LOOKASIDE_MISS_SIZE: i32 = 5;
pub const SQLITE_DBSTATUS_LOOKASIDE_MISS_FULL: i32 = 6;
pub const SQLITE_DBSTATUS_CACHE_HIT: i32 = 7;
pub const SQLITE_DBSTATUS_CACHE_MISS: i32 = 8;
pub const SQLITE_DBSTATUS_CACHE_WRITE: i32 = 9;
pub const SQLITE_DBSTATUS_DEFERRED_FKS: i32 = 10;
pub const SQLITE_DBSTATUS_CACHE_USED_SHARED: i32 = 11;
pub const SQLITE_DBSTATUS_MAX: i32 = 11;

pub const SQLITE_STMTSTATUS_FULLSCAN_STEP: i32 = 1;
pub const SQLITE_STMTSTATUS_SORT: i32 = 2;
pub const SQLITE_STMTSTATUS_AUTOINDEX: i32 = 3;
pub const SQLITE_STMTSTATUS_VM_STEP: i32 = 4;

pub const SQLITE_CHECKPOINT_PASSIVE: i32 = 0;
pub const SQLITE_CHECKPOINT_FULL: i32 = 1;
pub const SQLITE_CHECKPOINT_RESTART: i32 = 2;
pub const SQLITE_CHECKPOINT_TRUNCATE: i32 = 3;

pub const SQLITE_VTAB_CONSTRAINT_SUPPORT: i32 = 1;

pub const SQLITE_ROLLBACK: i32 = 1;
pub const SQLITE_FAIL: i32 = 3;
pub const SQLITE_REPLACE: i32 = 5;

pub const SQLITE_SCANSTAT_NLOOP: i32 = 0;
pub const SQLITE_SCANSTAT_NVISIT: i32 = 1;
pub const SQLITE_SCANSTAT_EST: i32 = 2;
pub const SQLITE_SCANSTAT_NAME: i32 = 3;
pub const SQLITE_SCANSTAT_EXPLAIN: i32 = 4;
pub const SQLITE_SCANSTAT_SELECTID: i32 = 5;
