pub enum MapmResult<T> {
    Success(T),
    Fail(MapmErr),
}

#[derive(Debug)]
pub enum MapmErr {
    ProblemErr(String),
    SolutionErr(String),
    ContestErr(String),
    TemplateErr(String),
}

use MapmResult::*;

impl<T> MapmResult<T> {
    pub fn unwrap(self) -> T {
        match self {
            Success(t) => t,
            _ => panic!("Could not unwrap MapmResult as it was not a success"),
        }
    }
}
