# Contests

mapm uses [problem files](problems) in your problems directory (defined in `~/.mapm/config.yml`) and [templates](template.md) in `~/.mapm/templates`.

To create a contest, create a file with a `.yml` extension. For instance, if we wanted to call our contest `MAT-2021`, we would create the file `MAT-2021.yml`. The filename of the compiled PDF will match this filename, so in this case, it will be `MAT-2021.pdf`. To make things easier we call the file `contest.yml`, but know the filename can be anything.

Contests must have an array with key `problems` that contains the names of each problem, and it must also have a string with key `template` corresponding to a template file. For instance, a very minimal example of a `contest.yml` would be

```yaml
template: minimal-template
problems:
  - tally-miscount
  - group-backwards
  - eamc-cyclic
  - angle-bisector-ptolemy
  - max-poly
  - monic-6th-degree
  - phi-fraction
  - tangent-ellipse
  - alexander-balls
```

If your template has variables, they **must** also be present in `contest.yml`. To make things simple, your variables may only take string values. So if your template's `config.yml` looks like

```yaml
engine: pdflatex
vars:
  - title
  - year
```

then a valid `contest.yml` might look like

```yaml
template: minimal-template
problems:
  - tally-miscount
  - group-backwards
  - eamc-cyclic
  - angle-bisector-ptolemy
  - max-poly
  - monic-6th-degree
  - phi-fraction
  - tangent-ellipse
  - alexander-balls
vars:
  title: Math Advancement Tournament
  year: 2021
```
