# Commands

The binary that you install is called `mapm` by default.

## help

**Usage:** `mapm help`

Displays the help page.

## build

**Usage:** `mapm build [FILE] [--draft]`

Builds the contest associated with FILE, which should be a `.yml`.

If the `--draft` flag is passed, mapm will only warn you about missing variables and use a blank string for them, instead of refusing to run.

## view

**Usage:** `mapm view [--FILEPATH] [hide] [show]`

An example is
```sh
$ mapm view --alexander-balls
```

By default, `view` will show every attribute of the problem. To modify this, you can either use the `hide` or `show` subcommand.

The hide and show subcommands are **mutually exclusive**.

### show

If you want to show certain attributes, you should use the `show` subcommand. For instance, to show the `difficulty` attribute of a problem, you could run
```sh
$ mapm view --alexander-balls show --difficulty
```

### hide

Perhaps you want to view every attribute of the problem besides the solutions. You could run
```sh
$ mapm view --alexander-balls hide --solutions
```

## find

**Usage:** `mapm find [--KEY=VALUE] [hide] [show]`

Returns all problems that satisfy **every** `--KEY<OPERATOR>VALUE` flag. Valid values of `<OPERATOR>` are `=`, `<`, `>`, `<=`, `>=`.

If no `--KEY<OPERATOR>VALUE` flags are passed, then every problem is returned.

An example is
```sh
$ mapm find --difficulty=3
```
which will return the name of every problem with difficulty 3.

To check for existence of a key, you can just use `mapm find --KEY`. So to look for every problem with the `solutions` key (which implies they have a solution), run
```sh
$ mapm find --solutions
```

You can check for non-equality or non-existence of a key by prepending it with an `!` character. For instance,
```sh
$ mapm find --!difficulty=3
```
returns all problems without difficulty 3. If you specifically want a difficulty to exist but want it *not* to be 3, then you can try
```sh
$ mapm find --difficulty --!difficulty=3
```

If your valid difficulties are 1-5, then you can get all problems with difficulties 1 and 2 by running
```sh
$ mapm find --difficulty --!difficulty=3 --!difficulty=4 --!difficulty=5
```

Since all your difficulties are integers (which is necessary in order to use any comparison operator besides `=`), you may also run
```sh
$ mapm find --difficulty
```

If you want to check for problems that don't have solutions (so you can write them), run
```sh
$ mapm find --!solutions
```

Each flag with a comparison operator implicitly requires the key to exist in the problem file. Thus, to get all problems with a difficulty not set to 3, run
```sh
$ mapm find --difficulty --!difficulty=3
```

### show

The functionality is identical to `show` from `view`.

### hide

The functionality is identical to `hide` from `view`.
