use crate::msg;

use mapm::problem::Views::*;
use mapm::problem::{fetch_problem, Solutions, Vars, Views};
use mapm::result::MapmErr::*;

use std::path::Path;

use colour::*;

/// Parses views given action: &(String, Vec<String>)

pub fn parse_views(action: &(String, Vec<String>)) -> Views {
    let views: Views;
    match action.0.as_str() {
        "hide" => {
            let mut views_vec: Vec<String> = Vec::new();
            for view in &action.1 {
                views_vec.push(String::from(view));
            }
            views = Hide(views_vec);
        }
        "show" => {
            let mut views_vec: Vec<String> = Vec::new();
            for view in &action.1 {
                views_vec.push(String::from(view));
            }
            views = Show(views_vec);
        }
        _ => {
            e_red_ln!("{}", msg::INVALID_SUBCMD);
            quit::with_code(exitcode::USAGE);
        }
    }
    views
}

pub fn problem_names_to_problems(
    profile: &str,
    problem_names: &Vec<String>,
    views: Views,
) -> Vec<(String, (Vars, Option<Solutions>))> {
    let config = dirs::config_dir().unwrap();
    let mut problems: Vec<(String, (Vars, Option<Solutions>))> = Vec::new();
    for problem_name in problem_names {
        let problem_result = fetch_problem(
            problem_name,
            &Path::new(&config)
                .join("mapm")
                .join("problems")
                .join(profile),
        );
        match problem_result {
            Ok(problem) => {
                problems.push((
                    String::from(problem_name),
                    problem.filter_keys(views.clone()),
                ));
            }
            Err(err) => match err {
                ProblemErr(msg) => {
                    e_yellow_ln!("{}", msg);
                }
                _ => {
                    e_magenta_ln!("{}", msg::VIEW_NOT_PROBLEMERR);
                    quit::with_code(exitcode::SOFTWARE);
                }
            },
        }
    }
    problems
}
