use std::io::Write;
use std::process::{Command, Stdio};
use which::which;

use mapm::problem::*;

use ansi_term::Colour::*;

pub fn problems_to_string(problems: Vec<(String, (Vars, Option<Solutions>))>) -> String {
    let mut problem_display = String::new();
    let mut problem_index = 0;
    for (problem_name, problem) in problems {
        problem_index += 1;
        if problem_index > 1 {
            problem_display.push_str("\n\n");
        }
        problem_display.push_str(
            &Green
                .bold()
                .paint(["-- ", &problem_name, " --"].concat())
                .to_string(),
        );
        for (key, val) in &problem.0 {
            problem_display.push_str("\n");
            problem_display.push_str(&Blue.paint(key).to_string());
            problem_display.push_str(": ");
            let mut idx = 0;
            for string in val.split("\n") {
                idx += 1;
                if idx == 1 {
                    problem_display.push_str(&string);
                } else {
                    problem_display.push_str("\n  ");
                    problem_display.push_str(&str::repeat(" ", key.chars().count()));
                    problem_display.push_str(&string);
                }
            }
        }
        match &problem.1 {
            Some(solutions) => {
                problem_display.push_str("\n");
                problem_display.push_str(&Blue.bold().paint("solutions").to_string());
                problem_display.push_str(": ");
                if solutions.len() == 0 {
                    problem_display.push_str(&Red.bold().paint("empty").to_string());
                } else {
                    let mut index: u32 = 0;
                    for solution in solutions {
                        index += 1;
                        problem_display.push_str("\n  ");
                        problem_display
                            .push_str(&Red.paint([&index.to_string(), "."].concat()).to_string());
                        let mut key_index = 0;
                        for (key, val) in solution {
                            key_index += 1;
                            if key_index == 1 {
                                problem_display.push_str(" ");
                            } else {
                                problem_display.push_str("\n");
                                problem_display.push_str(&str::repeat(" ", 5));
                            }
                            problem_display.push_str(&Blue.paint(key).to_string());
                            problem_display.push_str(": ");
                            let mut idx = 0;
                            for string in val.split("\n") {
                                idx += 1;
                                if idx == 1 {
                                    problem_display.push_str(&string);
                                } else {
                                    problem_display.push_str("\n");
                                    problem_display.push_str(&str::repeat(
                                        " ",
                                        index.to_string().len() + key.chars().count() + 6,
                                    ));
                                    problem_display.push_str(&string);
                                }
                            }
                        }
                    }
                }
            }
            None => {
                problem_display.push_str("\n");
            }
        }
    }
    return problem_display;
}

pub fn display(string: &str) {
    if matches!(which("less"), Ok(_)) {
        let mut process = match Command::new("less").arg("-R").stdin(Stdio::piped()).spawn() {
            Err(msg) => panic!("Couldn't spawn less`: {}", msg),
            Ok(process) => process,
        };

        match process.stdin.as_ref().unwrap().write_all(string.as_bytes()) {
            Err(msg) => panic!("Couldn't write to `less` stdin: {}", msg),
            Ok(_) => {}
        }

        process.wait().expect("`wait` failed");
    } else {
        println!("{}", string);
    }
}
