use std::fs;
use std::io;
use std::path::Path;

use colour::*;

pub fn setup() {
    let home = dirs::home_dir().unwrap();
    green_ln!(
        "You are setting the default profile for mapm right now. What would you like to call it?"
    );
    let mut profile = String::new();
    io::stdin()
        .read_line(&mut profile)
        .expect("Could not read input line");
    profile = String::from(profile.trim());
    if profile == "exit" || profile == "quit" {
        return;
    } else {
        fs::write(Path::new(&home).join(".mapm").join("profile"), &profile).unwrap();
        let problem_path = Path::new(&home)
            .join(".mapm")
            .join("problems")
            .join(&profile);
        if !problem_path.exists() {
            loop {
                green_ln!(
                    "Would you like to make the directory `{}`? (y/n)",
                    problem_path.to_str().unwrap()
                );
                let mut answer = String::new();
                io::stdin()
                    .read_line(&mut answer)
                    .expect("Could not read input line");
                answer = String::from(answer.trim());
                if &answer == "y" {
                    fs::create_dir(
                        Path::new(&home)
                            .join(".mapm")
                            .join("problems")
                            .join(&profile),
                    )
                    .expect("Could not create the directory.");
                    break;
                } else if &answer == "n" {
                    break;
                }
            }
        }
    }
}
