use colour::*;
use mapm::result::MapmErr;
use mapm::result::MapmErr::*;

// OK

pub static HELP: &str = "Usage: mapm [SUBCOMMAND]
Valid subcommands are `profile`, `view`, `preview`, `find`, `edit`, and `build`.
For more details on each of these subcommands, run them with the `--help` flag.
If you have an internet connection, it may also be worth perusing the documentation at
    https://mapm.mathadvance.org";

pub static HELP_VIEW: &str = "Usage: mapm view [--PROBLEM_NAMES...] [hide/show] [--KEYS...]
Displays the keys of every problem passed in.
You may only use one of the hide or show subcommands.
If you do not use either of them, then every key will be shown.";

pub static HELP_FIND: &str = "Usage: mapm find [--CRITERION] [hide/show] [--KEYS...]
Displays the keys each problem that satisfies a certain set of criterion.
If no criterion are passed in, all problems are displayed.
You may only use one of the hide or show subcommands.
If you do not use either of them, then every key will be shown.";

pub static HELP_BUILD: &str = "Usage: mapm build [FILES...]
Pass in the contest filename in order to build it.
If any problem, solution, or contest variables are missing, mapm will throw an error and refuse to build.";

pub static HELP_EDIT: &str = "Usage: mapm edit [PROBLEN_NAME]
Pass in the contest filename in order to build it.
If any problem, solution, or contest variables are missing, mapm will throw an error and refuse to build.
The --draft flag will make missing variables empty instead of throwing an error.";

pub static HELP_PROFILE: &str = "Usage: mapm build [FILE] [--draft]
Pass in the contest filename in order to build it.
If any problem, solution, or contest variables are missing, mapm will throw an error and refuse to build.
The --draft flag will make missing variables empty instead of throwing an error.";

// ERRORS

pub static TOO_MANY_ARGS: &str = "Too many arguments";

pub static MISSING_SUBCMD: &str = "Missing subcommand (\"mapm --help\" for help)";

pub static INVALID_SUBCMD: &str = "Invalid subcommand (\"mapm --help\" for help)";

pub static INVALID_VIEW_SUBCMD: &str = "Invalid subcommand (\"mapm view --help\" for help)";

pub static INVALID_FIND_SUBCMD: &str = "Invalid subcommand (\"mapm find --help\" for help)";

pub static INVALID_PROFILE_SUBCMD: &str = "Invalid subcommand (\"mapm profile --help\" for help)";

pub static MISSING_EDIT_ARG: &str =
    "Missing `PROBLEM_NAME` argument (\"mapm edit --help\" for help)";

pub static MISSING_PROFILE_ARG: &str =
    "Missing argument `get` or `set` (\"mapm profile --help\" for help)";

pub fn print_err(err: &MapmErr) {
    match err {
        ProblemErr(err) => {
            e_red_ln!("Problem error: {}", err);
        }
        ContestErr(err) => {
            e_red_ln!("Contest error: {}", err);
        }
        TemplateErr(err) => {
            e_red_ln!("Template error: {}", err);
        }
        SolutionErr(err) => {
            e_red_ln!("Solution error: {}", err);
        }
    }
}

// INTERNAL ERRORS

pub static VIEW_NOT_PROBLEMERR: &str =
    "Internal software error: `mapm view` failed with an error type other than `ProblemErr`
Please report this message to the developers.";

pub static FIND_NOT_PROBLEMERR: &str =
    "Internal software error: `mapm find` failed with an error type other than `ProblemErr`
Please report this message to the developers.";
